<form action="index.php?ToDo=viewStats" name="frmStats" id="frmStats" method="post">
	<input id="currentTab" name="currentTab" value="0" type="hidden">
	<div class="row">
		<div class="col-sm-12">
			<h4 class="page-title">{% lang 'StoreOverview' %}</h4>
			<p>{% lang 'StoreOverviewIntro' %}</p>
			{{ Message|safe }}
		</div>
	</div>

	<div class="row">
		<div class="col-sm-12">
			<ul id="tabnav" class="nav nav-tabs tabs">
				<li class="tab"><a href="#" class="active" id="tab0" onclick="ShowTab(0)">{% lang 'StoreSnapshot' %}</a></li>
				<li class="tab"><a href="#" id="tab1" onclick="ShowTab(1)">{% lang 'Top20Customers' %}</a></li>
				<li class="tab"><a href="#" id="tab2" onclick="ShowTab(2)">{% lang 'BestSellingProducts' %}</a></li>
				<br class="Clear" />
			</ul>
		</div>
	</div>

	<div class="row">
		<div class="col-sm-12 form-horizontal">
			<form name="customDateForm" method="post" action="index.php?Page=stats&Action=ProcessCalendar&SubAction=List&NextAction=ViewSummary&list=11" style="margin: 0px;">
				<fieldset class="col-md-3">
					<div class="form-group">
						<label class="col-md-2 control-label">Datas:</label>
						<div class="col-md-8">
							<div class="input-group">
								<select name="Calendar[DateType]" id="Calendar" class="CalendarSelect form-control" onchange="doCustomDate(this, 7)">
									<option value="Today">{% lang 'Today' %}</option>
									<option value="Yesterday">{% lang 'Yesterday' %}</option>
									<option value="Last24Hours">{% lang 'Last24Hours' %}</option>
									<option value="Last7Days">{% lang 'Last7Days' %}</option>
									<option value="Last30Days">{% lang 'Last30Days' %}</option>
									<option value="ThisMonth">{% lang 'ThisMonth' %}</option>
									<option value="LastMonth">{% lang 'LastMonth' %}</option>
									<option value="AllTime" SELECTED>{% lang 'AllTime' %}</option>
									<option value="Custom">{% lang 'Custom' %}</option>
								</select>
								<span class="input-group-btn">
									<button type="submit" class="btn waves-effect waves-light btn-primary"><i class="fa fa-search"></i></button>
								</span>
							</div>
						</div>
					</div>
					<div class="form-group" id=customDate7 style="display:none">
					<label class="col-md-2 control-label"></label>
					<div class="col-md-10">
						<select name="Calendar[From][Day]" class="CalendarSelectSmall">
								{{ OverviewFromDays|safe }}
							</select>
							<select name="Calendar[From][Mth]" class="CalendarSelectSmall">
								{{ OverviewFromMonths|safe }}
							</select>
							<select name="Calendar[From][Yr]" class="CalendarSelectSmall">
								{{ OverviewFromYears|safe }}
							</select>
							<span class=body>{% lang 'To1' %}</span>
							<select name="Calendar[To][Day]" class="CalendarSelectSmall">
								{{ OverviewToDays|safe }}
							</select>
							<select name="Calendar[To][Mth]" class="CalendarSelectSmall">
								{{ OverviewToMonths|safe }}
							</select>
							<select name="Calendar[To][Yr]" class="CalendarSelectSmall">
								{{ OverviewToYears|safe }}
							</select>
					</div>
				</div>
				</fieldset>
			</form>
		</div>
	</div>

	<div id="div0">
		<div class="row">
			<div class="col-md-6 col-sm-6 col-lg-3">
				<div class="mini-stat clearfix bx-shadow">
					<span class="mini-stat-icon bg-info"><i class="ion-social-usd"></i></span>
					<div class="mini-stat-info text-right text-muted">
						<span class="counter">{{ OverviewOrderTotal|safe }}</span>
						{% lang 'TotalRevenue' %}
					</div>
				</div>
			</div>

			<div class="col-md-6 col-sm-6 col-lg-3">
				<div class="mini-stat clearfix bx-shadow">
					<span class="mini-stat-icon bg-success"><i class="ion-eye"></i></span>
					<div class="mini-stat-info text-right text-muted">
						<span class="counter">{{ OverviewUniqueVisitors|safe }}</span>
						{% lang 'UniqueVisitors' %}
					</div>
				</div>
			</div>

			<div class="col-md-6 col-sm-6 col-lg-3">
				<div class="mini-stat clearfix bx-shadow">
					<span class="mini-stat-icon bg-purple"><i class="ion-ios7-cart"></i></span>
					<div class="mini-stat-info text-right text-muted">
						<span class="counter">{{ OverviewOrderCount|safe }}</span>
						{% lang 'CompletedOrders' %}
					</div>
				</div>
			</div>

			<div class="col-md-6 col-sm-6 col-lg-3">
				<div class="mini-stat clearfix bx-shadow">
					<span class="mini-stat-icon bg-primary"><i class="ion-stats-bars "></i></span>
					<div class="mini-stat-info text-right text-muted">
						<span class="counter">{{ OverviewConversionRate|safe }}</span>
						{% lang 'ConversionRate' %}
					</div>
				</div>
			</div>

			<strong><h4 class="text-center text-primary">{{ ChartTitle|safe }}</h4><span style="display:{{ HideNoAdvancedStatsMessage|safe }}; color:#CACACA"><br />({% lang 'NoOrderData2Days' %})</span></strong>
			<div id="flashcontent"></div>
			<script type="text/javascript" src="includes/amcharts/swfobject.js?{{ JSCacheToken }}"></script>
			<script type="text/javascript">
				$(document).ready(function() {
					var so = new SWFObject("{{ ShopPath|safe }}/admin/includes/amcharts/amline/amline.swf", "amline", "98%", "430", "8", "#FFFFFF");
					so.addVariable("path", "{{ ShopPath|safe }}/admin/includes/amcharts/");
					so.addVariable("wmode", "transparent");
					so.addVariable("settings_file", escape("{{ ShopPath|safe }}/admin/includes/amcharts/overviewgeneral.xml"));
					so.addVariable("data_file", escape("{{ ShopPath|safe }}/admin/index.php?ToDo=overviewStatsData&from={{ OverviewFromStamp|safe }}&to={{ OverviewToStamp|safe }}"));
					so.addVariable("preloader_color", "#000000");
					so.write("flashcontent");
				});
			</script>
		</div>
	</div>

	<div id="div1">
		{{ TopCustomersGrid|safe }}
		<div id="flashcontent1" style="width: 100%; border: solid 0px black; display:{{ HideTop20CustomersChart|safe }}"></div>
		<script type="text/javascript" src="includes/amcharts/swfobject.js?{{ JSCacheToken }}"></script>
		<script type="text/javascript">
			$(document).ready(function() {
				var so = new SWFObject("{{ ShopPath|safe }}/admin/includes/amcharts/ampie.swf", "ampie", "100%", "400", "8", "#FFFFFF");
				so.addVariable("path", "{{ ShopPath|safe }}/admin/includes/amcharts/");
				so.addVariable("settings_file", escape("{{ ShopPath|safe }}/admin/includes/amcharts/top20customers.xml"))
				so.addVariable("data_file", escape("{{ ShopPath|safe }}/admin/index.php?ToDo=overviewStatsTop20CustData&from={{ OverviewFromStamp|safe }}&to={{ OverviewToStamp|safe }}"));
				so.addVariable("preloader_color", "#999999");
				so.write("flashcontent1");
			});
		</script>
	</div>
	
	<div id="div2">
		{{ TopProductsGrid|safe }}

		<div id="flashcontent2" style="width: 100%; border: solid 0px black; display:{{ HideTop20ProductsChart|safe }}"></div>
		<script type="text/javascript">
		//<![CDATA[
			$(document).ready(function() {
				var so = new SWFObject("{{ ShopPath|safe }}/admin/includes/amcharts/ampie.swf", "ampie", "100%", "400", "8", "#FFFFFF");
				so.addVariable("path", "{{ ShopPath|safe }}/admin/includes/amcharts/");
				so.addVariable("settings_file", escape("{{ ShopPath|safe }}/admin/includes/amcharts/top20products.xml"))
				so.addVariable("data_file", escape("{{ ShopPath|safe }}/admin/index.php?ToDo=overviewStatsTop20Prods&from={{ OverviewFromStamp|safe }}&to={{ OverviewToStamp|safe }}"));
				so.addVariable("preloader_color", "#999999");
				so.write("flashcontent2");
			});
		//]]>
		</script>
	</div>
</form>

<script type="text/javascript">
	function ShowTab(T) {
		i = 0;

		while (document.getElementById("tab" + i) != null) {
			document.getElementById("div" + i).style.display = "none";
			document.getElementById("tab" + i).className = "";
			i++;
		}

		document.getElementById("div" + T).style.display = "";
		document.getElementById("tab" + T).className = "active";
		document.getElementById("currentTab").value = T;

		// What should the intro text be?
		switch(T) {
			case 0: {
				$('#introText').html('{{ IntroText0|safe }}');
				break;

			}
			case 1: {
				$('#introText').html('{{ IntroText1|safe }}');
				break;

			}
			case 2: {
				$('#introText').html('{{ IntroText2|safe }}');
				break;

			}
		}
	}

	$(document).ready(function() {

		ShowTab({{ CurrentTab|safe }});

		// Which date range is selected?
		var current_date = '{{ CurrentDate|safe }}';
		var Calendar = g('Calendar');

		for(i = 0; i < Calendar.options.length; i++) {
			if(Calendar.options[i].value == current_date) {
				Calendar.options[i].selected = true;
				break;
			}
		}

		// Is it custom? If so, show the custom date ranges
		if(current_date == 'Custom') {
			doCustomDate(g('Calendar'), 7);
		}
	});

	</script>
