<?php

CLASS ISC_CATEGORYCONTENT_PANEL extends PRODUCTS_PANEL
{
	public function SetPanelSettings(){
		$GLOBALS['ISC_CLASS_CATEGORY'] = GetClass('ISC_CATEGORY');

		if(GetConfig('EnableProductComparisons') == 0 || $GLOBALS['ISC_CLASS_CATEGORY']->GetNumProducts() < 2) {
			$GLOBALS['HideCompareItems'] = "none";
		}

	
		$GLOBALS['ISC_CLASS_CATEGORY']->GetProducts($products);
		$GLOBALS['CategoryProductListing'] = "";

		if(GetConfig('ShowProductRating') == 0) {
			$GLOBALS['HideProductRating'] = "display: none";
		}

		$display_mode = ucfirst(GetConfig("CategoryDisplayMode"));
		if ($display_mode == "Grid") {
			$display_mode = "";
		}
		$GLOBALS['DisplayMode'] = $display_mode;

		if ($display_mode == "List") {
			if (GetConfig('ShowAddToCartLink') && $GLOBALS['ISC_CLASS_CATEGORY']->GetNumProducts() > 0) {
				$GLOBALS['HideAddButton'] = '';
			} else {
				$GLOBALS['HideAddButton'] = 'none';
			}

			$GLOBALS['ListJS'] = $GLOBALS['ISC_CLASS_TEMPLATE']->GetSnippet("ListCheckForm");
		}

		$GLOBALS['CompareButton'] = $GLOBALS['ISC_CLASS_TEMPLATE']->GetSnippet("CompareButton" . $display_mode);

		if ($display_mode == "List" && $GLOBALS['ISC_CLASS_CATEGORY']->GetNumPages() > 1) {
			$GLOBALS['CompareButtonTop'] = $GLOBALS['CompareButton'];
		}

		$GLOBALS['AlternateClass'] = '';
		foreach($products as $row) {
			$this->setProductGlobals($row);

			if ($display_mode == "List") {
				$desc = isc_substr(strip_tags($row['proddesc']), 0, 225);
				if (isc_strlen($row['proddesc']) > 225) {
					$period_pos = isc_strrpos($desc, ".");
					$space_pos = isc_strrpos($desc, " ");
					if ($space_pos - 1 > $period_pos) {
						$pos = $space_pos;
					}
					else {
						$pos = $period_pos;
					}
					$desc = isc_substr($desc, 0, $pos);
					$desc .= "...";
				}

				$GLOBALS['ProductDescription'] = $desc;
				$GLOBALS['AddToCartQty'] = "";

				if (CanAddToCart($row) && GetConfig('ShowAddToCartLink')) {
					if (isId($row['prodvariationid']) || trim($row['prodconfigfields'])!='' || $row['prodeventdaterequired']) {
						$GLOBALS['AddToCartQty'] = '<a href="' . $GLOBALS["ProductURL"] . '">' . $GLOBALS['ProductAddText'] . "</a>";
					}else {
						$GLOBALS['CartItemId'] = $GLOBALS['ProductId'];
						if (GetConfig('TagCartQuantityBoxes') == 'dropdown') {
							$GLOBALS['Quantity0'] = "selected=\"selected\"";
							$GLOBALS['QtyOptionZero'] = '<option %%GLOBAL_Quantity0%% value="0">Quantidade</option>';
							$GLOBALS['QtySelectStyle'] = 'width: auto;';
							$GLOBALS['AddToCartQty'] = $GLOBALS['ISC_CLASS_TEMPLATE']->GetSnippet("CartItemQtySelect");
						} else {
							$GLOBALS['ProductQuantity'] = 0;
							$GLOBALS['AddToCartQty'] = $GLOBALS['ISC_CLASS_TEMPLATE']->GetSnippet("CartItemQtyText");
						}
					}
				}
			} // for grid style
			else {
				$GLOBALS["CompareOnSubmit"] = "onsubmit=\"return compareProducts(config.CompareLink)\"";
			}
			$GLOBALS['ProC'] = simulador_de_rodape($row['productid']);
			$GLOBALS['ProCBoleto'] = simulador_home1($row['productid']);
			$GLOBALS['CategoryProductListing'] .= $GLOBALS['ISC_CLASS_TEMPLATE']->GetSnippet("CategoryProductsItem" . $display_mode);
		}
		
		if($GLOBALS['ISC_CLASS_CATEGORY']->GetNumProducts() == 0) {
			// There are no products in this category
			//echo "fffffffffffff";
			//$GLOBALS['CategoryProductListing'] = $GLOBALS['ISC_CLASS_TEMPLATE']->GetSnippet("CategoryNoProductsMessage");
			//$GLOBALS['CategoryProductListing'] = "fffffffffffff";
			$GLOBALS['HideOtherProductsIn'] = 'none';
			$GLOBALS['SemProduto'] = "No h produtos nesta categoria";
			$GLOBALS['ExtraCategoryClass'] = "Wide WideWithLeft";
			if($GLOBALS['SNIPPETS']['SubCategories'] != '') {
				$GLOBALS['CategoryProductListing'] = '';
			}
			$GLOBALS['HideRightColumn'] = "none";
		}
		else {
			$GLOBALS['HideOtherProductsIn'] = 'block';
			$GLOBALS['OtherProductsIn'] = sprintf(GetLang('OtherProductsIn'), $GLOBALS['ISC_CLASS_CATEGORY']->GetName());
		}
	}
}