<form action="index.php?ToDo=viewSearchStats" name="frmStats" id="frmStats" method="post">
	<input id="currentTab" name="currentTab" value="0" type="hidden">

	<div class="row">
		<div class="col-sm-12">
			<h4 class="page-title">Estatsticas de Pesquisa <input type="button" name="clearSearchStats" value="Apagar Estatsticas" onclick="clearStatsClick()" class="btn btn-primary btn-sm" /></h4>
			<p>{% lang 'StoreOverviewIntro' %}</p>
			{{ Message|safe }}
		</div>
	</div>

	<div class="row">
		<div class="col-sm-12">
			<ul id="tabnav" class="nav nav-tabs">
				<li class="nav-item"><a href="#" class="active nav-link" id="tab0" onclick="ShowTab(0)">{% lang 'StatsOverview' %}</a></li>
				<li class="nav-item"><a href="#" id="tab1" class="nav-link" onclick="ShowTab(1)">{% lang 'SearchStatsKeywordsResults' %}</a></li>
				<li class="nav-item"><a href="#" id="tab2" class="nav-link" onclick="ShowTab(2)">{% lang 'SearchStatsKeywordsNoResults' %}</a></li>
				<li class="nav-item"><a href="#" id="tab3" class="nav-link" onclick="ShowTab(3)">{% lang 'SearchStatsBestPerforming' %}</a></li>
				<li class="nav-item"><a href="#" id="tab4" class="nav-link" onclick="ShowTab(4)">{% lang 'SearchStatsWorstPerforming' %}</a></li>
				<li class="nav-item"><a href="#" id="tab5" class="nav-link" onclick="ShowTab(5)">{% lang 'SearchStatsCorrections' %}</a></li>
				<br class="Clear" />
			</ul>
		</div>
	</div>

	<div id="div0" style="background: #fff; padding: 20px;">
		<div class="row">
			<div class="col-sm-12 form-horizontal">
				<fieldset class="col-md-3">
					<div class="form-group">
						<label class="col-md-2 control-label">Datas:</label>
						<div class="col-md-8">
							<select name="Calendar[DateType]" id="Calendar" class="CalendarSelect form-control">
								<option value="Today">{% lang 'Today' %}</option>
								<option value="Yesterday">{% lang 'Yesterday' %}</option>
								<option value="Last24Hours">{% lang 'Last24Hours' %}</option>
								<option value="Last7Days">{% lang 'Last7Days' %}</option>
								<option value="Last30Days">{% lang 'Last30Days' %}</option>
								<option value="ThisMonth">{% lang 'ThisMonth' %}</option>
								<option value="LastMonth">{% lang 'LastMonth' %}</option>
								<option value="AllTime" SELECTED>{% lang 'AllTime' %}</option>
							</select>
						</div>

						<div class="col-md-2">
							<input type="submit" value="Go" class="btn btn-primary" />
						</div>
					</div>
				</fieldset>
			</div>
		</div>
		<table width="100%" border="0" class="text" style="padding-left:10px; clear: both;">
			<tr>
				<td valign=top width="250" nowrap>
					<div class="MidHeading" style="width:100%"><img src="images/order.gif" align="absMiddle">&nbsp;{% lang 'OverviewSearchSummary' %}</div>
					<ul class="Text">
						<li>{% lang 'OverviewNoSearches' %}: {{ OverviewNumSearches|safe }}</li>
						<li>{% lang 'OverviewMostSearchesDay' %}: {{ OverviewMostSearchesDay|safe }}</li>
						<li>{% lang 'OverviewAvgSearchesDay' %}: {{ OverviewAverageSearchesDay|safe }}</li>
						<li>{% lang 'OverviewPopularTermsResults' %}: {{ OverviewMostPopularTerms|safe }}</li>
						<li>{% lang 'OverviewPopularTermsNoResults' %}: {{ OverviewMostPopularTermsNoResults|safe }}</li>
					</ul>
				</td>
				
				<td width="100%" align="center">
					<div style="display: {{ HideChart|safe }}">
						<strong>{{ ChartTitle|safe }}</strong>
						<div id="flashcontent" style="clear: both; width: 100%;"></div>
						<script type="text/javascript" src="includes/amcharts/swfobject.js?{{ JSCacheToken }}"></script>
						<script type="text/javascript">
							$(document).ready(function() {
								var so = new SWFObject("{{ ShopPath|safe }}/admin/includes/amcharts/ampie.swf", "ampie", "100%", "430", "8", "#FFFFFF");
								so.addVariable("path", "{{ ShopPath|safe }}/admin/includes/amcharts/");
								so.addVariable("settings_file", escape("{{ ShopPath|safe }}/admin/includes/amcharts/searchoverview.xml"));
								so.addVariable("data_file", escape("{{ ShopPath|safe }}/admin/index.php?ToDo=searchStatsOverviewData&from={{ OverviewFromStamp|safe }}&to={{ OverviewToStamp|safe }}"));
								so.addVariable("preloader_color", "#000000");
								so.write("flashcontent");
							});
						</script>
					</div>
				</td>
			</tr>
		</table>
	</div>
	
	<div id="div1" style="background: #fff; padding: 20px;">
		<div id="keywordsWithResultsGrid"></div>
	</div>
	
	<div id="div2" style="background: #fff; padding: 20px;">
		<div id="keywordsWithoutResultsGrid"></div>
	</div>
	
	<div id="div3" style="background: #fff; padding: 20px;">
		<div id="bestPerformingKeywordsGrid"></div>
	</div>
	
	<div id="div4" style="background: #fff; padding: 20px;">
		<div id="worstPerformingKeywordsGrid"></div>
	</div>
	
	<div id="div5" style="background: #fff; padding: 20px;">
		<div id="searchCorrectionsGrid"></div>
	</div>
</form>
<script type="text/javascript">
	var resultsPerPage = 20;
	var keywordsWithResultsLoaded = false;
	var keywordsWithResultsFromLink = false;
	var keywordsWithResultsCurrentPage = 1;
	var keywordsWithResultsSortField = '';
	var keywordsWithResultsSortOrder = '';
	var keywordsWithoutResultsLoaded = false;
	var keywordsWithoutResultsFromLink = false;
	var keywordsWithoutResultsCurrentPage = 1;
	var keywordsWithoutResultsSortField = '';
	var keywordsWithoutResultsSortOrder = '';
	var bestPerformingKeywordsLoaded = false;
	var bestPerformingKeywordsFromLink = false;
	var bestPerformingKeywordsCurrentPage = 1;
	var bestPerformingKeywordsSortField = '';
	var bestPerformingKeywordsSortOrder = '';
	var worstPerformingKeywordsLoaded = false;
	var worstPerformingKeywordsFromLink = false;
	var worstPerformingKeywordsCurrentPage = 1;
	var worstPerformingKeywordsSortField = '';
	var worstPerformingKeywordsSortOrder = '';
	var searchCorrectionsLoaded = false;
	var searchCorrectionsFromLink = false;
	var searchCorrectionsCurrentPage = 1;
	var searchCorrectionsSortField = '';
	var searchCorrectionsSortOrder = '';

	function ShowTab(T) {

		i = 0;

		while (document.getElementById("tab" + i) != null) {
			document.getElementById("div" + i).style.display = "none";
			document.getElementById("tab" + i).className = "";
			i++;
		}

		document.getElementById("div" + T).style.display = "";
		document.getElementById("tab" + T).className = "active";
		document.getElementById("currentTab").value = T;

		// What should the intro text be?
		switch(T) {
			case 0: {
				$('#introText').html('{% lang 'StatsSearchOverviewIntro1' %}');
				break;
			}
			case 1: {
				$('#introText').html('{% lang 'StatsSearchOverviewIntro2' %}');

				if(!keywordsWithResultsLoaded) {
					LoadKeywordsWithResultsGrid();
					keywordsWithResultsLoaded = true;
				}
				break;
			}
			case 2: {
				$('#introText').html('{% lang 'StatsSearchOverviewIntro3' %}');

				if(!keywordsWithoutResultsLoaded) {
					LoadKeywordsWithoutResultsGrid();
					keywordsWithoutResultsLoaded = true;
				}
				break;
			}
			case 3: {
				$('#introText').html('{% lang 'StatsSearchOverviewIntro4' %}');

				if(!bestPerformingKeywordsLoaded) {
					LoadBestPerformingKeywordsGrid();
					bestPerformingKeywordsLoaded = true;
				}
				break;
			}
			case 4: {
				$('#introText').html('{% lang 'StatsSearchOverviewIntro5' %}');

				if(!worstPerformingKeywordsLoaded) {
					LoadWorstPerformingKeywordsGrid();
					worstPerformingKeywordsLoaded = true;
				}
				break;
			}
			case 5: {
				$('#introText').html('{% lang 'StatsSearchOverviewIntro6' %}');

				if(!searchCorrectionsLoaded) {
					LoadSearchCorrectionsGrid();
					searchCorrectionsLoaded = true;
				}
				break;
			}
		}
	}

	function ChangeKeywordsWithResultsPerPage(ResultsPerPage) {
		// Change how many results are shown per page
		resultsPerPage = ResultsPerPage;
		keywordsWithResultsCurrentPage = 1;
		keywordsWithResultsFromLink = true;
		LoadKeywordsWithResultsGrid();
	}

	function ChangeKeywordsWithResultsPage(Page) {
		// Change which page of results we're viewing
		keywordsWithResultsCurrentPage = Page;
		keywordsWithResultsFromLink = true;
		LoadKeywordsWithResultsGrid();
	}

	function SortKeywordsWithResults(field, order) {
		keywordsWithResultsSortField = field;
		keywordsWithResultsSortOrder = order;
		keywordsWithResultsFromLink = true;
		LoadKeywordsWithResultsGrid();
	}

	function LoadKeywordsWithResultsGrid() {
		// Load the search keywords with results and jump to a specific page
		jQuery.ajax({url: 'index.php?ToDo=searchStatsWithResultsGrid&FromLink='+keywordsWithResultsFromLink+'&From={{ FromStamp|safe }}&To={{ ToStamp|safe }}&Page='+keywordsWithResultsCurrentPage+'&Show='+resultsPerPage+'&SortBy='+keywordsWithResultsSortField+'&SortOrder='+keywordsWithResultsSortOrder,
			     success: function(data) {
				$('#keywordsWithResultsGrid').html(data)
			     }
			}
		);
	}

	function ChangeKeywordsWithoutResultsPerPage(ResultsPerPage) {
		// Change how many results are shown per page
		resultsPerPage = ResultsPerPage;
		keywordsWithoutResultsCurrentPage = 1;
		keywordsWithoutResultsFromLink = true;
		LoadKeywordsWithoutResultsGrid();
	}

	function ChangeKeywordsWithoutResultsPage(Page) {
		// Change which page of results we're viewing
		keywordsWithoutResultsCurrentPage = Page;
		keywordsWithoutResultsFromLink = true;
		LoadKeywordsWithoutResultsGrid();
	}

	function SortKeywordsWithoutResults(field, order) {
		keywordsWithoutResultsSortField = field;
		keywordsWithoutResultsSortOrder = order;
		keywordsWithoutResultsFromLink = true;
		LoadKeywordsWithoutResultsGrid();
	}

	function LoadKeywordsWithoutResultsGrid() {
		// Load the search keywords without results and jump to a specific page
		jQuery.ajax({url: 'index.php?ToDo=searchStatsWithoutResultsGrid&FromLink='+keywordsWithoutResultsFromLink+'&From={{ FromStamp|safe }}&To={{ ToStamp|safe }}&Page='+keywordsWithoutResultsCurrentPage+'&Show='+resultsPerPage+'&SortBy='+keywordsWithoutResultsSortField+'&SortOrder='+keywordsWithoutResultsSortOrder,
			     success: function(data) {
				$('#keywordsWithoutResultsGrid').html(data)
			     }
			}
		);
	}

	function ChangeBestPerformingKeywordsPerPage(ResultsPerPage) {
		// Change how many results are shown per page
		resultsPerPage = ResultsPerPage;
		bestPerformingKeywordsCurrentPage = 1;
		bestPerformingKeywordsFromLink = true;
		LoadBestPerformingKeywordsGrid();
	}

	function ChangeBestPerformingKeywordsPage(Page) {
		// Change which page of results we're viewing
		bestPerformingKeywordsCurrentPage = Page;
		bestPerformingKeywordsFromLink = true;
		LoadBestPerformingKeywordsGrid();
	}

	function SortBestPerformingKeywords(field, order) {
		bestPerformingKeywordsSortField = field;
		bestPerformingKeywordsSortOrder = order;
		bestPerformingKeywordsFromLink = true;
		LoadBestPerformingKeywordsGrid();
	}

	function LoadBestPerformingKeywordsGrid() {
		// Load the best performing search keywords and jump to a specific page
		jQuery.ajax({url: 'index.php?ToDo=searchStatsBestPerformingGrid&FromLink='+bestPerformingKeywordsFromLink+'&From={{ FromStamp|safe }}&To={{ ToStamp|safe }}&Page='+bestPerformingKeywordsCurrentPage+'&Show='+resultsPerPage+'&SortBy='+bestPerformingKeywordsSortField+'&SortOrder='+bestPerformingKeywordsSortOrder,
			     success: function(data) {
				$('#bestPerformingKeywordsGrid').html(data)
			     }
			}
		);
	}

	function ChangeWorstPerformingKeywordsPerPage(ResultsPerPage) {
		// Change how many results are shown per page
		resultsPerPage = ResultsPerPage;
		worstPerformingKeywordsCurrentPage = 1;
		worstPerformingKeywordsFromLink = true;
		LoadWorstPerformingKeywordsGrid();
	}

	function ChangeWorstPerformingKeywordsPage(Page) {
		// Change which page of results we're viewing
		worstPerformingKeywordsCurrentPage = Page;
		worstPerformingKeywordsFromLink = true;
		LoadWorstPerformingKeywordsGrid();
	}

	function SortWorstPerformingKeywords(field, order) {
		worstPerformingKeywordsSortField = field;
		worstPerformingKeywordsSortOrder = order;
		worstPerformingKeywordsFromLink = true;
		LoadWorstPerformingKeywordsGrid();
	}

	function LoadWorstPerformingKeywordsGrid() {
		// Load the worst performing search keywords and jump to a specific page
		jQuery.ajax({url: 'index.php?ToDo=searchStatsWorstPerformingGrid&FromLink='+worstPerformingKeywordsFromLink+'&From={{ FromStamp|safe }}&To={{ ToStamp|safe }}&Page='+worstPerformingKeywordsCurrentPage+'&Show='+resultsPerPage+'&SortBy='+worstPerformingKeywordsSortField+'&SortOrder='+worstPerformingKeywordsSortOrder,
			     success: function(data) {
				$('#worstPerformingKeywordsGrid').html(data)
			     }
			}
		);
	}

	function ChangeSearchCorrectionsPerPage(ResultsPerPage) {
		// Change how many results are shown per page
		resultsPerPage = ResultsPerPage;
		searchCorrectionsCurrentPage = 1;
		searchCorrectionsFromLink = true;
		LoadSearchCorrectionsGrid();
	}

	function ChangeSearchCorrectionsPage(Page) {
		// Change which page of results we're viewing
		searchCorrectionsCurrentPage = Page;
		searchCorrectionsFromLink = true;
		LoadSearchCorrectionsGrid();
	}

	function SortSearchCorrections(field, order) {
		searchCorrectionsSortField = field;
		searchCorrectionsSortOrder = order;
		searchCorrectionsFromLink = true;
		LoadSearchCorrectionsGrid();
	}


	function LoadSearchCorrectionsGrid() {
		// Load the search corrections grid for the page we're viewing
		jQuery.ajax({url: 'index.php?ToDo=searchStatsCorrectionsGrid&FromLink='+searchCorrectionsFromLink+'&From={{ FromStamp|safe }}&To={{ ToStamp|safe }}&Page='+searchCorrectionsCurrentPage+'&Show='+resultsPerPage+'&SortBy='+searchCorrectionsSortField+'&SortOrder='+searchCorrectionsSortOrder,
			     success: function(data) {
				$('#searchCorrectionsGrid').html(data)
			     }
			}
		);
	}


	$(document).ready(function() {

		ShowTab({{ CurrentTab|safe }});

		// Which date range is selected?
		var current_date = '{{ CurrentDate|safe }}';
		var Calendar = g('Calendar');

		for(i = 0; i < Calendar.options.length; i++) {
			if(Calendar.options[i].value == current_date) {
				Calendar.options[i].selected = true;
				break;
			}
		}

		// Is it custom? If so, show the custom date ranges
		if(current_date == 'Custom') {
			doCustomDate(g('Calendar'), 7);
		}
	});

	function clearStatsClick()
	{
		if(confirm('{% lang 'ConfirmDeleteSearchStats' %}'))
			window.location = 'index.php?ToDo=clearSearchStats';
	}

	</script>
