<form action="index.php?ToDo=viewProdStats" name="frmStats" id="frmStats" method="post">
	<input id="currentTab" name="currentTab" value="0" type="hidden">

	<div class="row">
		<div class="col-sm-12">
			<h4 class="page-title">{% lang 'ProductStatistics' %}</h4>
			<p>{% lang 'ProductStatsIntro' %}</p>
			{{ Message|safe }}
		</div>
	</div>

	<div class="row">
		<div class="col-sm-12">
			<ul id="tabnav" class="nav nav-tabs tabs">
				<li class="tab"><a href="#" class="active" id="tab0" onclick="ShowTab(0)"><span class="btn btn-primary">{% lang 'ProductsByNumberSold' %}</span></a></li>
				<li class="tab"><a href="#" id="tab1" onclick="ShowTab(1)"><span class="btn btn-primary">{% lang 'MostViewedProducts' %}</span></a></li>
				<li class="tab" style="display: {{ HideInventoryTab|safe }};"><a href="#" id="tab2" onclick="ShowTab(2)"><span class="btn btn-primary">{% lang 'InventoryReport' %}</span></a></li>
				<br class="Clear" />
			</ul>
		</div>
	</div>

	<div class="row">
		<div class="col-sm-12 form-horizontal">
			<fieldset class="col-md-3">
				<div class="form-group">
					<label class="col-md-2 control-label">Datas:</label>
					<div class="col-md-8">
						<select name="Calendar[DateType]" id="Calendar" class="CalendarSelect form-control">
							<option value="Today">{% lang 'Today' %}</option>
							<option value="Yesterday">{% lang 'Yesterday' %}</option>
							<option value="Last24Hours">{% lang 'Last24Hours' %}</option>
							<option value="Last7Days">{% lang 'Last7Days' %}</option>
							<option value="Last30Days">{% lang 'Last30Days' %}</option>
							<option value="ThisMonth">{% lang 'ThisMonth' %}</option>
							<option value="LastMonth">{% lang 'LastMonth' %}</option>
							<option value="AllTime" SELECTED>{% lang 'AllTime' %}</option>
						</select>
					</div>

					<div class="col-md-2">
						<input type="submit" value="Go" class="btn btn-primary" />
					</div>
				</div>
			</fieldset>
		</div>
	</div>
	
	<div id="div0" class="text">
		<div id="productsByNumSoldGrid"></div>
	</div>
	
	<div id="div1" class="text">
		<div id="productsByNumViewsGrid"></div>
	</div>
	
	<div id="div2" style="display: {{ HideInventoryTab|safe }};" class="text">
		<div id="productsByInventoryGrid"></div>
	</div>
</form>
	<script type="text/javascript">

		var productsPerPage = 20;

		var productsByNumSoldCurrentPage = 1;
		var productsByNumSoldLoaded = false;
		var productsByNumSoldSortField = '';
		var productsByNumSoldSortOrder = '';

		var productsByNumViewsCurrentPage = 1;
		var productsByNumViewsLoaded = false;
		var productsByNumViewsSortField = '';
		var productsByNumViewsSortOrder = '';

		var productsByInventoryVariations = 1;
		var productsByInventoryCurrentPage = 1;
		var productsByInventoryLoaded = false;
		var productsByInventorySortField = '';
		var productsByInventorySortOrder = '';

		var showProductInventory = '{{ ShowInventoryGrid|safe }}';

		function ShowTab(T) {

			i = 0;

			while (document.getElementById("tab" + i) != null) {
				document.getElementById("div" + i).style.display = "none";
				document.getElementById("tab" + i).className = "";
				i++;
			}

			document.getElementById("div" + T).style.display = "";
			document.getElementById("tab" + T).className = "active";
			document.getElementById("currentTab").value = T;

			// What should the intro text be?
			switch(T) {
				case 0: {
					$('#introText').html('{% lang 'ProductsByNumSoldIntro' %}');
					$('#dateBlock .dateField').show();
					$('#dateBlock .GoButton').show();
					$('#ShowHideVariationsButtonContainer').hide();
					if(!productsByNumSoldLoaded) {
						LoadProductsByNumSoldGrid();
						productsByNumSoldLoaded = true;
					}
					break;
				}
				case 1: {
					$('#introText').html('{% lang 'ProductsByNumViewsIntro' %}');
					$('#dateBlock .dateField').hide();
					$('#ShowHideVariationsButtonContainer').hide();
					if($('#dateBlock .VendorSelect').css('display') != 'none') {
						$('#dateBlock .GoButton').show();
					}
					else {
						$('#dateBlock .GoButton').hide();
					}
					if(!productsByNumViewsLoaded) {
						LoadProductsByNumViewsGrid();
						productsByNumViewsLoaded = true;
					}
					break;
				}
				case 2: {
					if (showProductInventory !== '1') {
						break;
					}
					$('#ShowHideVariationsButtonContainer').show();
					$('#introText').html('{% lang 'ProductsByInventoryIntro' %}');
					$('#dateBlock .dateField').hide();
					if($('#dateBlock .VendorSelect').css('display') != 'none') {
						$('#dateBlock .GoButton').show();
					}
					else {
						$('#dateBlock .GoButton').hide();
					}
					if(!productsByInventoryLoaded) {
						LoadProductsByInventoryGrid();
						productsByInventoryLoaded = true;
					}
					break;
				}
			}
		}

		function ChangeProductsByNumSoldPerPage(ProductsPerPage) {
			// Change how many products are shown per page
			productsPerPage = ProductsPerPage;
			productsByNumSoldCurrentPage = 1;
			LoadProductsByNumSoldGrid();
		}

		function ChangeProductsByNumSoldPage(Page) {
			// Change which page of orders we're viewing
			productsByNumSoldCurrentPage = Page;
			LoadProductsByNumSoldGrid();
		}

		function SortProductsByNumSold(field, order) {
			productsByNumSoldSortField = field;
			productsByNumSoldSortOrder = order;
			LoadProductsByNumSoldGrid();
		}

		function ChangeProductsByNumViewsPerPage(ProductsPerPage) {
			// Change how many products are shown per page
			productsPerPage = ProductsPerPage;
			productsByNumViewsCurrentPage = 1;
			LoadProductsByNumViewsGrid();
		}

		function ChangeProductsByNumViewsPage(Page) {
			// Change which page of orders we're viewing
			productsByNumViewsCurrentPage = Page;
			LoadProductsByNumViewsGrid();
		}

		function SortProductsByNumViews(field, order) {
			productsByNumViewsSortField = field;
			productsByNumViewsSortOrder = order;
			LoadProductsByNumViewsGrid();
		}

		function ChangeProductsByInventoryPerPage(ProductsPerPage) {
			// Change how many products are shown per page
			productsPerPage = ProductsPerPage;
			productsByInventoryCurrentPage = 1;
			LoadProductsByInventoryGrid();
		}

		function ChangeProductsByInventoryVariations() {
			productsByInventoryVariations = productsByInventoryVariations ? 0 : 1;

			var buttonText = '{% lang 'ShowVariations' %}';
			if (productsByInventoryVariations) {
				buttonText = '{% lang 'HideVariations' %}';
			}
			$('#ShowHideVariationsButton').val(buttonText);

			productsByInventoryCurrentPage = 1;
			LoadProductsByInventoryGrid();
		}

		function ChangeProductsByInventoryPage(Page) {
			// Change which page of orders we're viewing
			productsByInventoryCurrentPage = Page;
			LoadProductsByInventoryGrid();
		}

		function SortProductsByInventory(field, order) {
			productsByInventorySortField = field;
			productsByInventorySortOrder = order;
			LoadProductsByInventoryGrid();
		}

		function LoadProductsByNumSoldGrid() {
			jQuery.ajax({url: 'index.php?ToDo=prodStatsByNumSoldGrid&vendorId={{ VendorId|safe }}&From={{ FromStamp|safe }}&To={{ ToStamp|safe }}&Page='+productsByNumSoldCurrentPage+'&Show='+productsPerPage+'&SortBy='+productsByNumSoldSortField+'&SortOrder='+productsByNumSoldSortOrder,
					 success: function(data) {
					$('#productsByNumSoldGrid').html(data);
					 }
				}
			);
		}

		function LoadProductsByNumViewsGrid() {
			jQuery.ajax({url: 'index.php?ToDo=prodStatsByNumViewsGrid&vendorId={{ VendorId|safe }}&Page='+productsByNumViewsCurrentPage+'&Show='+productsPerPage+'&SortBy='+productsByNumViewsSortField+'&SortOrder='+productsByNumViewsSortOrder,
					 success: function(data) {
					$('#productsByNumViewsGrid').html(data);
					 }
				}
			);
		}

		function LoadProductsByInventoryGrid() {
			if (showProductInventory !== '1') {
				return;
			}

			jQuery.ajax({url: 'index.php?ToDo=prodStatsByInventoryGrid&vendorId={{ VendorId|safe }}&Variations='+productsByInventoryVariations+'&Page='+productsByInventoryCurrentPage+'&Show='+productsPerPage+'&SortBy='+productsByInventorySortField+'&SortOrder='+productsByInventorySortOrder,
					 success: function(data) {
					$('#productsByInventoryGrid').html(data);
					 }
				}
			);
		}

		$(document).ready(function() {

			ShowTab({{ CurrentTab|safe }});

			// Which date range is selected?
			var current_date = '{{ CurrentDate|safe }}';
			var Calendar = g('Calendar');

			for(i = 0; i < Calendar.options.length; i++) {
				if(Calendar.options[i].value == current_date) {
					Calendar.options[i].selected = true;
					break;
				}
			}

			// Is it custom? If so, show the custom date ranges
			if(current_date == 'Custom') {
				doCustomDate(g('Calendar'), 7);
			}

		});

	</script>
