<div class="BodyContainer">
	<form name="frmCurrency" id="frmCurrency" method="post" action="index.php?ToDo=settingsSaveCurrencySettings" onsubmit="return ValidateForm(CheckCurrencyForm);">
		<input type="hidden" name="currentTab" id="currentTab" value="0" />
		<div class="row">
			<div class="col-sm-12">
				<h4 class="page-title">{% lang 'Currency' %}</h4>
				<p>{{ CurrencyIntro|safe }}</p>
				{{ Message|safe}}
			</div>
		</div>

		<div class="row">
			<div class="col-sm-12">
				<ul id="tabnav" class="nav nav-tabs tabs ui-tabs ui-widget ui-widget-content ui-corner-all">
					{{ CurrencyTabs|safe }}
					<li><a href="#" class="active" id="tab1" onclick="ShowTab(1)">{% lang 'CurrencyRateSettings' %}</a></li>
				</ul>
			</div>
		</div>
		<br>

		<div id="div0" style="padding-top: 10px;">
			<div class="row">
				<div class="col-sm-12">
					<input type="button" name="IndexAddButton" value="{% lang 'AddCurrency' %}..." id="IndexCreateButton" class="SmallButton btn btn-primary" onclick="document.location.href='index.php?ToDo=settingsAddCurrency'" />&nbsp;

					<input type="button" name="IndexDeleteButton" value="{% lang 'DeleteSelected' %}" id="IndexDeleteButton" class="SmallButton btn btn-danger" onclick="ConfirmDeleteSelected()" {{ DisableDelete|safe }} />&nbsp;
					
					{{ UpdateExchageRateButton|safe }}
				</div>
			</div>

			<div class="row">
				<div class="col-sm-12">
					<br>
					<div class="panel panel-default">
						<div class="panel-body" style="padding: 0">
							<table class="GridPanel table table-striped" cellspacing="0" cellpadding="0" border="0" style="width:100%;">
								<thead>
									<tr style="display: {{ ShowCurrencyTableHeaders|safe }}">
										<th style="width:18px"><input type="checkbox" onclick="ToggleDeleteBoxes(this.checked)"></th>
										<th>&nbsp;</th>
										<th>{% lang 'CurrencyName' %}</th>
										<th>{% lang 'Currency' %}</th>
										<th>{% lang 'ExchangeRate' %}</th>
										<th style="width:70px;">{% lang 'Status' %}</th>
										<th style="width:120px;">{% lang 'Action' %}</th>
									</tr>
								</thead>

								<tbody>
									{{ CurrencyGrid|safe }}
								</tbody>
							</table>
						</div>
					</div>
				</div>
			</div>
		</div>

		<div id="div1" style="padding-top: 10px;">
			<div class="panel panel-default">
				<div class="panel-heading"> 
					<h3 class="panel-title">{% lang 'ExchangeRateSettings' %}</h3> 
				</div> 

				<div class="panel-body">
					<div class="form-group row">
						<label class="col-md-2 control-label">
							{% lang 'CurrencyMethods' %}:
						</label>
						<div class="col-md-10">
							<select size="8" multiple name="converterproviders[]" id="converterproviders" class="form-control Field250 ISSelectReplacement">
								{{ ConverterProviders|safe }}
							</select>
						</div>
					</div>
				</div>
			</div>

			<div class="panel panel-default">
				<div class="panel-heading"> 
					<h3 class="panel-title">{% lang 'AutomaticExchangeRateUpdates' %}</h3> 
				</div> 

				<div class="panel-body">
					<div class="alert alert-info">{% lang 'AutomaticExchangeRateUpdatesHelp' %}</div>
					<div class="form-group row">
						<label class="col-md-2 control-label">
							{% lang 'ExchangeRateCronCommand' %}:
						</label>
						<div class="col-md-10">
							<input type="text" class="form-control" name="cronpath" id="cronpath" value="{{ ExchangeRatePath|safe }}" />
						</div>
					</div>
				</div>
			</div>
			<div class="row">
				<div class="col-sm-12">
					<input type="submit" name="IndexCreateButton" value="{% lang 'Save' %}" id="IndexCreateButton" class=" btn btn-primary">
					<input type="reset" onclick="ConfirmCancel()" value="{% lang 'Cancel' %}" class="btn btn-danger">
				</div>
			</div>
		</div>
	</form>
</div>

<script type="text/javascript">
	var updateExchageRateSequency = new Array();
	var PopupPositioned = false;

	function ToggleDeleteBoxes(Status) {
		var fp = document.getElementById("frmCurrency").getElementsByTagName('input');

		for (var i=0; i < fp.length; i++) {
			if (!fp[i].getAttribute('disabled'))
				fp[i].checked = Status;
		}
	}

	function getSelected() {
		var inputs = document.getElementById("frmCurrency").getElementsByTagName('input');
		var nodes  = new Array();

		for (var i=0; i<inputs.length; i++) {
			if (inputs[i].type == "checkbox" && inputs[i].name == "currencies[]" && inputs[i].checked)
				nodes[nodes.length] = inputs[i];
		}

		return nodes
	}

	function hasSelected() {
		var nodes = getSelected();
		return nodes.length > 0;
	}

	function ConfirmDeleteSelected() {
		if (hasSelected()) {
			if (confirm("{% lang 'ConfirmDeleteCurrency' %}")) {
				$('#frmCurrency').attr('action', 'index.php?ToDo=settingsDeleteCurrencies');
				document.getElementById("frmCurrency").submit();
			}
		} else {
			alert("{% lang 'ChooseCurrencyDelete' %}");
		}
	}

	function ConfirmUpdateSelectedExchangeRate() {
		var nodes = getSelected();

		if (nodes.length > 0) {
			if (confirm("{% lang 'ConfirmUpdateCurrencyExchangeRate' %}")) {
				var spans  = document.getElementById("frmCurrency").getElementsByTagName('span');
				var substr = "currencyexchangeratestatus-";

				for (var i=(spans.length-1); i>=0; i--) {
					if (spans[i].id.substring(0, substr.length) == substr) {
						var parent = spans[i].parentNode;
						parent.removeChild(spans[i]);
					}
				}

				updateExchageRateSequency = new Array();

				for (var i=0; i<nodes.length; i++)
					updateExchageRateSequency[updateExchageRateSequency.length] = nodes[i].value;

				updateExchangeRate(updateExchageRateSequency[0], 0);
			}
		} else {
			alert("{% lang 'ChooseCurrencyUpdate' %}");
		}
	}

	function updateExchangeRate(id, seq) {
		$.ajax({
			url     : url,
			data    : "w=updateExchangeRate&cid={{ SelectedCurrencyModuleId|safe }}&currencyid=" + id + "&seq=" + seq,
			async   : true,
			cache   : false,
			success : ProcessData
		});
	}

	function ProcessData(data) {
		eval('var data = ' + data);
		var currencyExchangeRateNode = document.getElementById("currencyexchangerate-" + data.id);
		var statusNode               = document.createElement("span");
		var text, colour;

		statusNode.id                = "currencyexchangeratestatus-" + data.id;
		statusNode.style.marginLeft  = "10px";
		statusNode.style.fontSize    = "0.8em";
		statusNode.style.fontWeight  = "bold";

		switch (data.status) {
			case 0:
				colour = "green";
				text   = "({% lang 'CurrencyExchangeRateUpdateSuccess' %})";
				currencyExchangeRateNode.innerHTML = data.newRate;
				break;
			case 2:
				colour = "blue";
				text   = "({% lang 'CurrencyExchangeRateUpdateInvalid' %})";
				break;
			case 1:
			default:
				colour = "red";
				text   = "({% lang 'CurrencyExchangeRateUpdateFailed' %})";
				break;
		}

		statusNode.style.color = colour;
		statusNode.appendChild(document.createTextNode(text));
		currencyExchangeRateNode.appendChild(statusNode);

		if (data.seq < (updateExchageRateSequency.length - 1))
			window.setTimeout("updateExchangeRate(" + updateExchageRateSequency[data.seq+1] + ", " + (data.seq+1) + ");", 1);
	}

	function ConfirmCancel() {
		if(confirm("{% lang 'ConfirmCancelCurrencySettings' %}")) {
			document.location.href = "index.php?ToDo=viewCurrencySettings";
		}
	}

	function ShowTab(T) {
		i = 0;
		while (document.getElementById("tab" + i) != null) {
			document.getElementById("div" + i).style.display = "none";
			document.getElementById("tab" + i).className = "";
			i++;
		}

		document.getElementById("div" + T).style.display = "";
		document.getElementById("tab" + T).className = "active";
		document.getElementById("currentTab").value = T;
	}

	function CheckCurrencyForm() {
		if ($("#currencytype2").attr('checked')) {
			if (isNaN(priceFormat($("#DefaultCurrency").val())) || $("#DefaultCurrency").val() < 0) {
				alert("{% lang 'EnterACurrency' %}");
				$("#DefaultCurrency").focus();
				$("#DefaultCurrency").select();
				return false;
			}
		}
		return true;
	}

	function ConfirmSetAsDefault(currencyId) {
		$("#{{ PopupID|safe }}ButtonYes").click(function() { location.href = "index.php?ToDo=settingsSetAsDefaultCurrency&currencyId=" + currencyId + "&updatePrice=0" });
		$("#{{ PopupID|safe }}ButtonYesPrice").click(function() { location.href = "index.php?ToDo=settingsSetAsDefaultCurrency&currencyId=" + currencyId + "&updatePrice=1" });
		$("#{{ PopupID|safe }}ButtonNo").click(function() { $("#{{ PopupID|safe }}").hide("slow"); });

		if (!PopupPositioned) {
			$("#{{ PopupID|safe }}").css("left", (($(window).width() - $("#{{ PopupID|safe }}").width()) / 2) + "px");
			$("#{{ PopupID|safe }}").css("top", (($(window).height() - $("#{{ PopupID|safe }}").height()) / 2) + "px");
			PopupPositioned = true;
		}

		$("#{{ PopupID|safe }}").show("slow", function() { $("#{{ PopupID|safe }}ButtonYes").focus(); });
	}

	$(document).ready(function() {
		ShowTab({{ DefaultTab|safe }});
	});
</script>

<div class="Popup" id="{{ PopupID|safe }}" style="display:{{ PopupDisplay|safe }};">
	<div class="PopupToolbar">
		<div class="PopupToolbarLeftCorner"></div>
		<div class="PopupToolbarRightCorner"></div>
		<div class="PopupToolbarTools">
			<ul>
				<li><img src="images/popupbuttonclose.gif" alt="" border="0" onclick="$('#{{ PopupID|safe }}').hide('slow');" /></li>
				{{ PopupTools|safe }}
			</ul>
		</div>
	</div>
	
	<div class="PopupDocument">
		<div class="PopupDocumentImg" style="display:{{ PopupImgDisplay|safe }}">
			<img src="{{ PopupImgSrc|safe }}" />
		</div>
		
		<div class="PopupDocumentBody">
			<p><h2>{{ PopupHeader|safe }}</h2></p>
			<p>{{ PopupContent|safe }}</p>
		</div>
	</div>
</div>