	<div class="row">
		<div class="col-sm-12">
			<h4 class="page-title">{% lang 'ViewProductVariations' %}</h4>
			<p>{% lang 'ViewVariationsIntro' %}</p>
			<div id="PagesStatus">{{ Message|safe }}</div>
		</div>
	</div>

	<div class="row">
		<div class="col-sm-12">
			<input type="button" name="IndexAddButton" value="{% lang 'AddProductVariation' %}..." id="IndexCreateButton" class="btn btn-primary" onclick="document.location.href='index.php?ToDo=addProductVariation'" />
			<input type="button" name="IndexDeleteButton" value="{% lang 'DeleteSelected' %}" id="IndexDeleteButton" class="btn btn-danger" onclick="ConfirmDeleteSelected()" {{ DisableDelete|safe }} />
			<input type="button" name="IndexImportButton" value="{% lang 'ImportProductVariations' %}" id="IndexImportButton" class="btn btn-success" onclick="window.location='index.php?ToDo=importProductVariations';" {{ DisableImport|safe }} />
		</div>
	</div>
	<br />

	<div class="panel panel-default" style="display:{{ DisplayGrid|safe }}">
		<div class="panel-body pn">
			<div class="table-responsive">
				<form name="frmVariations" id="frmVariations" method="post" action="index.php?ToDo=deleteProductVariations">
					<div class="GridContainer">
						{{ VariationDataGrid|safe }}
					</div>
				</form>
			</div>
		</div>
	</div>

	<script type="text/javascript">

		var variationForm = document.getElementById('frmVariations');

		function ConfirmDeleteSelected() {
			var fp = variationForm.elements;
			var selected = [];

			for(i = 0; i < fp.length; i++) {
				if(fp[i].type == "checkbox" && fp[i].checked)
					selected[selected.length] = fp[i].value;
			}

			if(selected.length == 0) {
				alert("{% jslang 'ChooseVariations' %}");
				return;
			}

			if (!confirm("{% jslang 'ConfirmDeleteVariations' %}")) {
				return;
			}

			$.post('remote.php?remoteSection=product_variations&w=getAffectedVariations&actionType=delete&variationIdx=' + selected.join(), null,
				function(result) {
					if (result == '0') {
						// submit immediately if nothing is affected
						window.parent.variationForm.submit();
					} else if (result == '1') {
						// display a thickbox with all the affected products in it
						// from there they can decide whether to proceed or cancel
						$.iModal({
							type: 'ajax',
							url: 'remote.php?remoteSection=product_variations&w=viewAffectedVariations&actionType=delete&variationIdx=' + selected.join(),
							width: 600
						});
					}
				}
			);
		}

		function ToggleDeleteBoxes(Status) {
			var fp = document.getElementById("frmVariations").elements;

			for(i = 0; i < fp.length; i++) {
				fp[i].checked = Status;
			}
		}

		{% if updateSessionId %}
			$.iModal({
				type: 'ajax',
				method: 'post',
				url: 'remote.php',
				urlData: {
					remoteSection: 'product_variations',
					w: 'initRebuildVariations',
					session: '{{ updateSessionId }}'
				},
				close: false,
				width: 400
			});
		{% endif %}
	</script>
