<form enctype="multipart/form-data" action="index.php?ToDo={{ FormAction|safe }}" id="frmVariation" method="post">
<input type="hidden" name="variationId" id="productId" value="{{ VariationId|safe }}">
<div class="BodyContainer">
	<div class="row">
		<div class="col-sm-12">
			<h4 class="page-title">{{ Title|safe }}</h4>
			<p>{% lang 'ViewVariationsIntro' %}</p>
			{{ Message|safe}}
			<div class="alert alert-warning" style="display: {{ HideVariationTestDataWarning|safe }};">{% lang 'ProductVariationTestDataWarning' %}</div>
		</div>
	</div>

	<div class="row">
		<div class="col-sm-12">
			<input type="button" value="{% lang 'SaveAndExit' %}" class="btn btn-primary" onclick="SaveVariationForm()" />
			<input type="button" value="{{ SaveAndAddAnother|safe }}" onclick="SaveVariationForm(true)" class="btn btn-primary" />
			<input type="reset" value="{% lang 'Cancel' %}" class="btn btn-default" onclick="ConfirmCancel()" />
		</div>
	</div>
	<br />

	<div class="row">
		<div class="col-sm-12">
			<div class="panel panel-default">
				<div class="panel-heading"> 
					<h3 class="panel-title">{% lang 'VariationDetails' %}</h3> 
				</div> 

				<div class="panel-body">
					<div class="form-group row" style="{{ HideVendorOption|safe }}">
						<label class="col-md-2 control-label">
							{% lang 'Vendor' %}:
						</label>
						<div class="col-md-10">
							<span style="{{ HideVendorLabel|safe }}">{{ CurrentVendor|safe }}</span>
							<select name="vendor" id="vendor" class="form-control" style="{{ HideVendorSelect|safe }}">
								{{ VendorList|safe }}
							</select>
						</div>
					</div>

					<div class="form-group row">
						<label class="col-md-2 control-label">
							{% lang 'VariationName' %}:
						</label>
						<div class="col-md-10">
							<input type="text" id="vname" name="vname" class="form-control" value="{{ VariationName|safe }}">
						</div>
					</div>

					<div class="form-group row">
						<label class="col-md-2 control-label">
							{% lang 'VariationOptions' %}:
						</label>
						<div class="col-md-10">
							<ul id="ProductVariationBox">
								{{ Variations|safe }}
							</ul>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<div class="row">
		<div class="col-sm-12">
			<input type="button" value="{% lang 'SaveAndExit' %}" class="btn btn-primary" onclick="SaveVariationForm()" />
			<input type="button" value="{{ SaveAndAddAnother|safe }}" onclick="SaveVariationForm(true)" class="btn btn-primary" />
			<input type="reset" value="{% lang 'Cancel' %}" class="btn btn-default" onclick="ConfirmCancel()" />
		</div>
	</div>
</div>
</form>

<script type="text/javascript">

	var variationForm = document.getElementById('frmVariation');
	var affectedVariations = [{{ AffectedVariations|safe }}];

	function SaveVariationForm(addAnother) {
		if (!CheckVariationForm()) {
			return;
		}

		if (addAnother == true) {
			var f = g('frmVariation');
			var d = document.createElement('input');
			d.type = 'hidden';
			d.name = 'addanother';
			d.value = '1';
			f.appendChild(d);
		}

		variationForm.submit();
	}

	function ConfirmCancel() {
		if(confirm("{% lang 'ConfirmCancelVariation' %}"))
			document.location.href = "index.php?ToDo=viewProductVariations";
	}

	function CheckVariationForm() {
		if($('#vname').val() == '') {
			alert('{% lang 'ProductVariationErrorNoVariationName' %}');
			$('#vname').focus();
			return false;
		}

		var rowCount = 0;
		var rowPass = true;

		$("#ProductVariationBox .VariationRow").each(function() {

			var valueCount = 0;
			var valuePass = true;

			if ($(".VariationOptionName", this).val() == '') {
				alert(('{% lang 'ProductVariationErrorNoOptionName' %}').replace(/%d/, (rowCount+1)));
				$(".VariationOptionName").focus();
				rowPass = false;
				return false;
			}

			$(".VariationValueName", this).each(function() {
				if ($(this).val() == '') {
					alert(('{% lang 'ProductVariationErrorNoOptionValue' %}').replace(/%d/, (rowCount+1)));
					$(this).focus();
					valuePass = false;
					return false;
				}

				if ($(this).val().search("#") != -1) {
					alert(('{% lang 'ProductVariationErrorHash' %}').replace(/%d/, (rowCount+1)));
					$(this).focus();
					valuePass = false;
					return false;
				}

				valueCount++;
			});

			if (!valuePass) {
				rowPass = false;
				return false;
			}

			if (valueCount <= 1) {
				alert(('{% lang 'ProductVariationErrorInvalidOptions' %}').replace(/%d/, (rowCount+1)));
				$(".VariationValueName:first", this).focus();
				rowPass = false;
				return false;
			}

			rowCount++;
		});

		if (!rowPass) {
			return false;
		}

		if (rowCount == 0) {
			alert('{% lang 'ProductVariationErrorNoData' %}');
			return false;
		}

		return true;
	}

	function GetNextColumnID()
	{
		var matches, nextId = 0;

		$("#ProductVariationBox .VariationColumn .VariationOptionName").each(
			function() {
				matches = this.name.match(/variationOptionName\[([0-9]+)\]/);
				if (matches) {
					nextId = Math.max(nextId, matches[1]);
				}
			}
		);

		nextId++;

		return nextId;
	}

	function getNextValueID(valueRow)
	{
		var matches, parentId, nextId = 0;

		$(".VariationValue .VariationValueName", valueRow).each(
			function() {
				matches = this.name.match(/variationOptionValue\[([0-9]+)\]\[([0-9]+)\]/);
				if (matches) {
					parentId = matches[1];
					nextId = Math.max(nextId, matches[2]);
				}
			}
		);

		nextId++;

		return {"nextId": nextId, "parentId": parentId};
	}

	function AddVariationRow(addButton) {
		$("#ProductVariationBox .VariationRowDel").each(function() { $(this).show(); });

		var row = $(addButton.parentNode.parentNode).clone();
		var next = GetNextColumnID();

		var box = $(".VariationValues .VariationValue:first", row).clone();
		$(".VariationDel", box).each(function() { $(this).hide(); });
		$(".VariationValues", row).empty();
		$(".VariationValues", row).append(box);

		$(".VariationColumn .VariationOptionName", row).attr("name", "variationOptionName[" + next + "]");
		$(".VariationColumn .VariationOptionName", row).attr("id", "variationOptionName_" + next);
		$(".VariationColumn .VariationOptionName", row).val("");

		$(".VariationValues .VariationValue .VariationValueName", row).attr("name", "variationOptionValue[" + next + "][0]");
		$(".VariationValues .VariationValue .VariationValueName", row).attr("id", "variationOptionValue_" + next + "_0");
		$(".VariationValues .VariationValue .VariationValueName", row).val("");
		$(".VariationValues .VariationValue .VariationValueId", row).attr("name", "variationOptionValueId[" + next + "][0]");
		$(".VariationValues .VariationValue .VariationValueId", row).attr("id", "variationOptionValueId_" + next + "_0");
		$(".VariationValues .VariationValue .VariationValueId", row).val("");
		$(".VariationValuesRank", row).attr("name", "variationOptionValuesRank[" + next + "]");
		$(".VariationValuesRank", row).attr("id", "variationOptionValuesRank_" + next);

		AddSortableToValuesDiv($(".VariationValues", row));

		$(addButton.parentNode.parentNode).after(row);
		$(".VariationColumn .VariationOptionName", row).focus();
	}

	function DelVariationRow(delButton) {
		var parent = delButton.parentNode.parentNode.parentNode;
		var child = delButton.parentNode.parentNode;
		var total = 0;

		$(".VariationRow", parent).each(function() { total++; });
		if (total <= 1) {
			return false;
		}

		parent.removeChild(child);

		if (total == 2) {
			$(".VariationRow .VariationRowDel", parent).each(function() { $(this).hide(); });
		}
	}

	function AddVariationValue(addButton) {
		$(".VariationValue .VariationDel", addButton.parentNode.parentNode).each(function() { $(this).show(); });

		var box = $(addButton.parentNode).clone();
		var next = getNextValueID(addButton.parentNode.parentNode);

		$(".VariationValueName", box).attr("name", "variationOptionValue[" + next.parentId + "][" + next.nextId + "]");
		$(".VariationValueName", box).attr("id", "variationOptionValue_" + next.parentId + "_" + next.nextId);
		$(".VariationValueId", box).attr("name", "variationOptionValueId[" + next.parentId + "][" + next.nextId + "]");
		$(".VariationValueId", box).attr("id", "variationOptionValueId_" + next.parentId + "_" + next.nextId);
		$("input", box).val("");

		$(addButton.parentNode).after(box);
		$("#variationOptionValue_" + next.parentId + "_" + next.nextId).focus();
	}

	function DelVariationValue(delButton) {
		var parent = delButton.parentNode.parentNode;
		var child = delButton.parentNode;
		var total = 0;

		$(".VariationValue", parent).each(function() { total++; });
		if (total <= 1) {
			return false;
		}

		parent.removeChild(child);

		if (total == 2) {
			$(".VariationValue .VariationDel", parent).each(function() { $(this).hide(); });
		}
	}

	function AddSortableToValuesDiv(div) {
		$(div).sortable({"container": "parent"});
	}

	function AddSortableToContainer() {
		$("#ProductVariationBox").sortable({"container": "parent"});
	}

	$(document).ready(
		function() {
			$("#ProductVariationBox .VariationValues").each(function() { AddSortableToValuesDiv(this); });
			AddSortableToContainer();
		}
	);
</script>