<div class="row" id="filterBlock" style="display: {{ ShowVariationFilter|safe }}">
	<div class="col-md-6">
		<div class="panel panel-default">
			<div class="panel-heading"> 
				<h3 class="panel-title">{% lang 'SearchFilter' %}</h3> 
			</div> 

			<div class="panel-body">
				<div class="form-group" id="filterForm">
					<div id="optionList" class="row">
						{{ FilterOptions|safe }}
					</div>
					<input type="button" value="{% lang 'ApplyFilter' %}" id="applyFilter" class="btn btn-primary" /> {% lang 'ResetFilter' %}
				</div>
			</div>
		</div>
	</div>

	<div class="col-md-6">
		<div class="panel panel-default">
			<div class="panel-heading"> 
				<h3 class="panel-title">{% lang 'BulkUpdate' %}</h3> 
			</div> 

			<div class="panel-body">
				<div class="form-group" id="bulkUpdateForm">
					<input type="hidden" name="filterOptions" value="{{ FilterOptionsQuery|safe }}" />
					<div class="form-group row">
						<label class="col-md-2 control-label">{% lang 'CanBePurchased' %}:</label>
						<div class="col-md-10">
							<select name="updatePurchaseable" class="form-control">
								<option value="noupdate">{% lang 'DoNotUpdate' %}</option>
								<option value="reset">{% lang 'ResetField' %}</option>
								<option value="yes">{% lang 'SYes' %}</option>
								<option value="no">{% lang 'SNo' %}</option>
							</select>
						</div>
					</div>

					<div class="form-group row">
						<label class="col-md-2 control-label">{% lang 'VariationPrice' %}:</label>
						<div class="col-md-10">
							<select name="updatePriceDiff" id="updatePriceDiff" onchange="if (this.selectedIndex > 1) { $(this).next('span').show(); $(this).next('span').find('input').focus(); } else { $(this).next('span').hide(); }" class="form-control">
								<option value="noupdate">{% lang 'DoNotUpdate' %}</option>
								<option value="reset">{% lang 'ResetField' %}</option>
								<option value="add">{% lang 'VariationAdd' %}</option>
								<option value="subtract">{% lang 'VariationSubtract' %}</option>
								<option value="fixed">{% lang 'VariationFixed' %}</option>
							</select>

							<span style='display: none'>
								{{ CurrencyTokenLeft|safe }} <input name="updatePrice" id="updatePrice" type='text' class='NumberField'/> {{ CurrencyTokenRight|safe }}
							</span>
						</div>
					</div>

					<div class="form-group row">
						<label class="col-md-2 control-label">{% lang 'VariationWeight' %}:</label>
						<div class="col-md-10">
							<select class="form-control" name="updateWeightDiff" id="updateWeightDiff" onchange="if (this.selectedIndex > 1) { $(this).next('span').show(); $(this).next('span').find('input').focus(); } else { $(this).next('span').hide(); }">
								<option value="noupdate">{% lang 'DoNotUpdate' %}</option>
								<option value="reset">{% lang 'ResetField' %}</option>
								<option value="add">{% lang 'VariationAdd' %}</option>
								<option value="subtract">{% lang 'VariationSubtract' %}</option>
								<option value="fixed">{% lang 'VariationFixed' %}</option>
							</select>
							
							<span style='display: none'>
								<input name="updateWeight" id="updateWeight" type='text' class='NumberField' /> {{ WeightMeasurement|safe }}
							</span>
						</div>
					</div>

					<div class="form-group row">
						<label class="col-md-2 control-label">{% lang 'Image' %}:</label>
						<div class="col-md-10">
							<input type="file" name="updateImage" id="updateImage" />
							<label>
								<input type="checkbox" name="updateDelImages" id="updateDelImages" value="1" style="width: auto;" />
								{% lang 'YesDeleteImages' %}
							</label>
						</div>
					</div>

					<div class="form-group row VariationStockColumn" style="display: {{ HideInv|safe }}">
						<label class="col-md-2 control-label">{% lang 'CurrentStockLevel' %}:</label>
						<div class="col-md-10">
							<input class="NumberField" name="updateStockLevel" id="updateStockLevel" type="text" />
						</div>
					</div>

					<div class="form-group row VariationStockColumn" style="display: {{ HideInv|safe }}">
						<label class="col-md-2 control-label">{% lang 'LowStockLevel1' %}:</label>
						<div class="col-md-10">
							<input class="NumberField" name="updateLowStockLevel" id="updateLowStockLevel" type="text" />
						</div>
					</div>

					<input class="SubmitButton btn btn-primary" type="button" value="{% lang 'ApplyToAll' %}" id="bulkUpdate" />
				</div>
			</div>
		</div>
	</div>
</div>
<table class="GridPanel SortableGrid table table-striped" style="width:100%" id="optionGrid">
	<tr>
		<td colspan="{{ ColSpan|safe }}" class="VariationSpanRow">
			<table cellspacing="0" cellpadding="0" border="0" style="width: 100%;">
				<td align="right" class="PagingNav" style="padding:6px 0px 6px 0px; width: 100%;">
					{{ Nav|safe }}
				</td>
			</table>
		</td>
	</tr>
	<tr>
		<th><span class="HelpText" onmouseout="HideQuickHelp(this);" onmouseover="ShowQuickHelp(this, '{% lang 'EnableDisableAll' %}', '{% lang 'EnableDisableAllHelp' %}');"><input type='checkbox' checked='checked' onclick="$('#optionGrid').find('input[type=checkbox]').attr('checked', this.checked)" /></span></th>
		{{ HeaderRows|safe }}
		<th>{% lang 'SKU' %}</th>
		<th><span class="HelpText" onmouseout="HideQuickHelp(this);" onmouseover="ShowQuickHelp(this, '{% lang 'VariationPrice' %}', '{% lang 'VariationPriceHelp' %}');">{% lang 'VariationPrice' %}</span></th>
		<th><span class="HelpText" onmouseout="HideQuickHelp(this);" onmouseover="ShowQuickHelp(this, '{% lang 'VariationWeight' %}', '{% lang 'VariationWeightHelp' %}');">{% lang 'VariationWeight' %}</span></th>
		<th><span class="HelpText" onmouseout="HideQuickHelp(this);" onmouseover="ShowQuickHelp(this, '{% lang 'Image' %}', '{% lang 'VariationImageHelp' %}');">{% lang 'Image' %}</span></th>
		<th style="display:{{ HideInv|safe }}" class="VariationStockColumn"><span class="HelpText" onmouseout="HideQuickHelp(this);" onmouseover="ShowQuickHelp(this, '{% lang 'StockLevel' %}', '{% lang 'StockLevelHelp' %}');">{% lang 'StockLevel' %}</span></th>
		<th style="display:{{ HideInv|safe }}" class="VariationStockColumn"><span class="HelpText" onmouseout="HideQuickHelp(this);" onmouseover="ShowQuickHelp(this, '{% lang 'LowStockLevel' %}', '{% lang 'LowStockLevelHelp' %}');">{% lang 'LowStockLevel' %}</span></th>
	</tr>
	{{ VariationRows|safe }}
	<tr>
		<td colspan="{{ ColSpan|safe }}" class="VariationSpanRow">
			<table cellspacing="0" cellpadding="0" border="0" style="width: 100%;">
				<td align="right" class="PagingNav" style="padding:6px 0px 6px 0px; width: 100%;">
					{{ Nav|safe }}
				</td>
			</table>
		</td>
	</tr>
</table>
<script type="text/javascript">
	$("#applyFilter").click(function() {
		var formData = $('#filterForm :input').serializeArray();
		var showInv = '0';
		if ($('#prodInvTrack_2').attr('checked')) {
			showInv = 1;
		}

		$(this).parents('.GridContainer').load('remote.php?w=getVariationCombinations&productId={{ VProductId|safe }}&productHash={{ VProductHash|safe }}&v={{ VariationId|safe }}&inv=' + showInv, formData, function() {
			BindAjaxGridSorting();
			BindGridRowHover();
		});
	});

	$("#bulkUpdate").click(function() {
		var formData = $('#bulkUpdateForm :input').serialize();
		var showInv = '0';
		if ($('#prodInvTrack_2').attr('checked')) {
			showInv = 1;
		}

		// validate the price
		if ($("#updatePriceDiff").attr('selectedIndex') > 1) {
			if (isNaN(priceFormat($("#updatePrice").val())) || $("#updatePrice").val() == '' || $("#updatePrice").val() < 0) {
				alert("{% lang 'UpdateEnterValidPrice' %}");
				$("#updatePrice").focus();
				return;
			}
		}

		// validate the weight
		if ($("#updateWeightDiff").attr('selectedIndex') > 1) {
			if (isNaN($("#updateWeight").val()) || $("#updateWeight").val() == '' || $("#updateWeight").val() < 0) {
				alert("{% lang 'UpdateEnterValidWeight' %}");
				$("#updateWeight").focus();
				return;
			}
		}

		// validate stock levels
		if (showInv) {
			if (isNaN($("#updateStockLevel").val()) || $("#updateStockLevel").val() < 0) {
				alert("{% lang 'UpdateEnterValidStock' %}");
				$("#updateStockLevel").focus();
				return;
			}

			if (isNaN($("#updateLowStockLevel").val()) || $("#updateLowStockLevel").val() < 0) {
				alert("{% lang 'UpdateEnterValidLowStock' %}");
				$("#updateLowStockLevel").focus();
				return;
			}
		}

		$('#LoadingIndicator').show();

		$.ajaxFileUpload({
			url: 'remote.php?w=bulkUpdateVariations&productId={{ VProductId|safe }}&productHash={{ VProductHash|safe }}&v={{ VariationId|safe }}&inv=' + showInv + '&' + formData,
			secureuri: false,
			fileElementId: 'updateImage',
			dataType: 'json',
			success: function(data) {
				$("#bulkUpdate").parents('.GridContainer').html(data.tableData);

				BindAjaxGridSorting();
				BindGridRowHover();
			}
		});

		$('#LoadingIndicator').hide();

		return;
	});

	$("#showFilter").change(function() {
		$("#filterBlock").slideToggle('normal');
		SetCookie('showVariationFilter', $(this).attr('checked'), 365);
	});

	function resetFilter() {
		$("#optionList select").each(function() {
			$(this).find('option').removeAttr('selected');
			$(this).find('option:first').attr('selected', 'selected');
		});

		$("#applyFilter").click();
	}
</script>
