<div class="ModalTitle">
	{% lang 'OrderNotesPopupHeading' %}
</div>
<div class="ModalContent">
	<div class="alert alert-warning">{% lang 'OrderNotesPopupIntro' %}</div>

	<form action="" id="notesForm">
		<input type="hidden" id="orderId" name="orderId" value="{{ OrderID|safe }}" />
		<div class="panel panel-default">
			<div class="panel-heading"> 
				<h3 class="panel-title">{% lang 'OrderComments' %}</h3> 
			</div> 

			<div class="panel-body">
				<textarea id="ordcustmessage" name="ordcustmessage" rows="8" class="form-control">{{ OrderCustomerMessage|safe }}</textarea>
			</div>
		</div>

		<div class="panel panel-default">
			<div class="panel-heading"> 
				<h3 class="panel-title">{% lang 'StaffNotes' %}</h3> 
			</div> 

			<div class="panel-body">
				<textarea id="ordnotes" name="ordnotes" rows="8" class="form-control">{{ OrderNotes|safe }}</textarea>
			</div>
		</div>
	</form>
</div>
<div class="ModalButtonRow">
	<div class="FloatLeft">
		<img src="images/loading.gif" alt="" style="vertical-align: middle; display: none;" class="LoadingIndicator" />
		<input type="button" class="CloseButton FormButton btn btn-default" value="{% lang 'Cancel' %}" onclick="$.modal.close();" />
	</div>
	<input type="button" name="SaveNotesButton" class="Submit btn btn-primary" value="{% lang 'Save' %}" onclick="{% if order.deleted %}Order.showOrderDeletedGeneralNotice();{% else %}Order.SaveNotes('{{ ThankYouID|safe }}'){% endif %}" />
</div>

<script type="text/javascript">
	lang.OrderCommentsDefault = '{% lang 'OrderCommentsDefault' %}';
	lang.OrderNotesDefault = '{% lang 'OrderNotesDefault' %}';

	function ShowOrderCommentsDefault()
		{
			$('#ordcustmessage')
				.val(lang.OrderCommentsDefault)
				.data('usingDefault', 1)
				.addClass('OrderDefaultField')
				.attr('name', 'ordcustmessage_default')
			;
		}

		function ShowOrderNotesDefault()
		{
			$('#ordnotes')
				.val(lang.OrderNotesDefault)
				.data('usingDefault', 1)
				.addClass('OrderDefaultField')
				.attr('name', 'ordnotes_default')
			;
		}

		if(!$('#ordcustmessage').val()) {
			ShowOrderCommentsDefault();
			$('#ordcustmessage')
				.focus(function() {
					if($(this).data('usingDefault') != 1) {
						return;
					}
					$(this)
						.val('')
						.attr('name', 'ordcustmessage')
						.removeClass('OrderDefaultField')
					;
				})
				.blur(function() {
					if(!$(this).val()) {
						ShowOrderCommentsDefault();
					}
					else {
						$(this)
							.data('usingDefault', 0)
						;
					}
				})
			;
		}

		if(!$('#ordnotes').val()) {
			ShowOrderNotesDefault();
			$('#ordnotes')
				.focus(function() {
					if($(this).data('usingDefault') != 1) {
						return;
					}
					$(this)
						.val('')
						.attr('name', 'ordnotes')
						.removeClass('OrderDefaultField')
					;
				})
				.blur(function() {
					if(!$(this).val()) {
						ShowOrderNotesDefault();
					}
					else {
						$(this)
							.data('usingDefault', 0)
						;
					}
				})
			;
		}
</script>
