{% import "macros/util.tpl" as util %}
{% import "macros/forms.tpl" as formBuilder %}
<form enctype="multipart/form-data" action="index.php?ToDo={{ FormAction|safe }}" onsubmit="return CheckCouponForm();" id="frmNews" method="post">
	<input type="hidden" id="couponId" name="couponId" value="{{ CouponId|safe }}">
	<input type="hidden" id="couponexpires" name="couponexpires" value="">
	<input type="hidden" id="couponCode" name="couponcode" value="{{ CouponCode|safe }}">
	<input id="currentTab" name="currentTab" value="0" type="hidden" />

	<div class="row">
		<div class="col-sm-12">
			<h4 class="page-title">{{ Title|safe }}</h4>
			<p>{{ Intro|safe }}</p>
			<div id="MessageTmpBlock">{{ Message|safe }}</div>
		</div>
	</div>

	<div class="row">
		<div class="col-sm-12">
			<input type="submit" name="SubmitButton1" value="{% lang 'Save' %}" class="FormButton btn btn-primary">
			<input type="button" name="CancelButton1" value="{% lang 'Cancel' %}" class="FormButton btn btn-default" onclick="ConfirmCancel()"></p>
		</div>
	</div>
	<br />

	<div id="div0">
		<div class="panel panel-default form-horizontal">
			<div class="panel-heading"> 
				<h3 class="panel-title">{% lang 'NewCouponDetails' %}</h3> 
			</div> 

			<div class="panel-body">
				<div class="form-group">
					<label class="col-md-2 control-label">{% lang 'CouponCode' %}</label>
					<div class="col-md-10">
						<input type="text" id="couponcode" name="couponcode" class="form-control" value="{{ CouponCode|safe }}" />
					</div>
				</div>

				<div class="form-group">
					<label class="col-md-2 control-label">{% lang 'CouponName' %}</label>
					<div class="col-md-10">
						<input type="text" id="couponname" name="couponname" class="form-control" value="{{ CouponName|safe }}">
					</div>
				</div>

				<div class="form-group">
					<label class="col-md-2 control-label">{% lang 'DiscountType' %}</label>
					<div class="col-md-10">
						<div class="radio radio-primary">
							<input type="radio" name="coupontype" id="coupontype1" value="2" />
							<label for="coupontype1">Valor de desconto em dinheiro do total do pedido</label>
			            </div>

						<div class="radio radio-primary">
							<input type="radio"  name="coupontype" id="coupontype2" value="0" />
							<label for="coupontype2">Valor de desconto em dinheiro de cada item no pedido</label>
			            </div>

						<div class="radio radio-primary">
							<input type="radio" name="coupontype" id="coupontype3" value="1" />
							<label for="coupontype3">Percentual de desconto de cada item no pedido</label>
			            </div>

						<div class="radio radio-primary">
							<input type="radio" name="coupontype" id="coupontype4" value="3" />
							<label for="coupontype4">Valor de desconto em dinheiro do total do frete</label>
			            </div>

						<div class="radio radio-primary">
							<input type="radio" name="coupontype" id="coupontype5" value="4" />
							<label for="coupontype5">Frete grtis</label>
			            </div>
					</div>
				</div>

				<div class="form-group">
					<label class="col-md-2 control-label">Valor do desconto</label>
					<div class="col-md-10">
						<input type="text" id="couponamount" name="couponamount" class="form-control" value="{{ CouponAmount|safe }}" />
					</div>
				</div>

				<div class="form-group">
					<label class="col-md-2 control-label">{% lang 'MinimumPurchase' %}</label>
					<div class="col-md-10">
						<input type="text" id="couponminpurchase" name="couponminpurchase" class="form-control" value="{{ MinPurchase|safe }}">
					</div>
				</div>

				<div class="form-group">
					<label class="col-md-2 control-label">{% lang 'ExpiryDate' %}</label>
					<div class="col-md-10">
						<div class="input-group">
							<span class="input-group-addon">
								<a href="javascript:void(0)" onclick="if(self.gfPop)gfPop.fStartPop(document.getElementById('dc1'),document.getElementById('dc2'));return false;" HIDEFOCUS>
									<i class="md md-event"></i>
								</a>
							</span>
							<input class="plain form-control" id="dc1" value="{{ ExpiryDate|safe }}" size="12" onfocus="this.blur()" readonly>
						</div>
					</div>
				</div>

				<div class="form-group">
					<label class="col-md-2 control-label">{% lang 'CouponMaxUsesTitle' %}</label>
					<div class="col-md-10">
						<div class="checkbox checkbox-primary">
							<input type="checkbox" id="CouponMaxUsesEnabled" name="CouponMaxUsesEnabled" value="1" {% if CouponMaxUsesEnabled %}checked="checked"{% endif %}>
							<label for="CouponMaxUsesEnabled">{% lang 'CouponMaxUses' %}</label>
			            </div>

			            <div class="NodeJoin" id="CouponMaxUsesNode" {% if CouponMaxUsesEnabled == false %}style="display: none;"{% endif %}>
			            	<input type="text" id="couponmaxuses" name="couponmaxuses" class="Field50 form-control" value="{{ MaxUses|safe }}" />
			            </div>

						<div class="checkbox checkbox-primary">
							<input type="checkbox" id="CouponMaxUsesPerCustomerEnabled" name="CouponMaxUsesPerCustomerEnabled" value="1" {% if CouponMaxUsesPerCustomerEnabled %}checked="checked"{% endif %}>
							<label for="CouponMaxUsesPerCustomerEnabled">{% lang 'CouponMaxUsesPerCustomer' %}</label>
			            </div>

			            <div class="NodeJoin" id="CouponMaxUsesPerCustomerNode" {% if CouponMaxUsesPerCustomerEnabled == false %}style="display: none;"{% endif %}>
			            	<input type="text" id="couponmaxusespercus" name="couponmaxusespercus" class="form-control Field50" value="{{ MaxUsesPerCus|safe }}" />
			            </div>
			        </div>
			    </div>

				<div class="form-group">
					<label class="col-md-2 control-label">{% lang 'Enabled' %}</label>
					<div class="col-md-10">
						<div class="checkbox checkbox-primary">
							<input type="checkbox" id="couponenabled" name="couponenabled" value="ON" {{ Enabled|safe }}>
							<label for="couponenabled">{% lang 'YesCouponEnabled' %}</label>
			            </div>
			        </div>
			    </div>
			</div>
		</div>

		<div class="panel panel-default form-horizontal">
			<div class="panel-heading"> 
				<h3 class="panel-title">{% lang 'CouponAppliesTo' %}</h3> 
			</div> 

			<div class="panel-body">
				<div class="form-group">
					<label class="col-md-2 control-label">{% lang 'AppliesTo' %}</label>
					<div class="col-md-10">
						<input onclick="ToggleUsedFor(0)" type="radio" id="usedforcat" name="usedfor" value="categories" {{ UsedForCat|safe }}> <label for="usedforcat">{% lang 'CouponAppliesToCategories' %}</label><br />
						<div id="usedforcatdiv" style="padding-left:25px">
							<select multiple="multiple" size="12" name="catids[]" id="catids" class="Field250 ISSelectReplacement">
								<option value="0" {{ AllCategoriesSelected|safe }}>{% lang 'AllCategories' %}</option>
								{{ CategoryList|safe }}
							</select>

							<img onmouseout="HideHelp('ChooseCategoriesHelp');" onmouseover="ShowHelp('ChooseCategoriesHelp', '{% lang 'ChooseCategories' %}', '{% lang 'ChooseCategoriesHelp' %}')" src="images/help.gif" width="24" height="16" border="0">
							<div style="display:none" id="ChooseCategoriesHelp"></div>
						</div>
						<div style="clear: left;" />
							<input onclick="ToggleUsedFor(1)" type="radio" id="usedforprod" name="usedfor" value="products">
							<label for="usedforprod">{% lang 'CouponAppliesToProducts' %}</label><br />
							<div id="usedforproddiv" style="padding-left:25px">
								<select size="12" name="products" id="ProductSelect" class="Field250" onchange="$('#ProductRemoveButton').attr('disabled', false);">
									{{ SelectedProducts|safe }}
								</select>
								<div class="Field250" style="text-align: left;">
									<div style="float: right;">
										<input type="button" value="{% lang 'CouponRemoveSelected' %}" id="ProductRemoveButton" disabled="disabled" class="btn btn-danger btn-sm" onclick="removeFromProductSelect('ProductSelect', 'prodids');" />
									</div>
									<input type="button" value="{% lang 'CouponAddProduct' %}" class="btn btn-primary btn-sm" onclick="openProductSelect('coupon', 'ProductSelect', 'prodids');" />
									<input type="hidden" name="prodids" id="prodids" class="Field250" value="{{ ProductIds|safe }}" />
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>

		<div class="panel panel-default form-horizontal">
			<div class="panel-heading"> 
				<h3 class="panel-title">Aplicao</h3> 
			</div> 

			<div class="panel-body">
		{{ formBuilder.startForm() }}

			{{ formBuilder.heading(lang.LocationRestrictionSettings) }}
			{{ formBuilder.startRow([
				'label': lang.LimitByLocation ~ '?',
				'for': 'YesLimitByLocation',
			]) }}

				{{ formBuilder.checkbox([
					'name': 'YesLimitByLocation',
					'id': 'YesLimitByLocation',
					'label': lang.YesLimitByLocation,
					'value': 1,
					'checked': locationRestricted,
					'class': 'CheckboxTogglesOtherElements',
				]) }}
				{{ util.tooltip('LimitByLocation', 'LimitByLocation_Help') }}

			{{ formBuilder.endRow() }}

			{{ formBuilder.startRowGroup([ 'class': 'ShowIf_YesLimitByLocation_Checked', 'hidden': not locationRestricted ]) }}

				{{ formBuilder.startRow([
					'label': ' ',
				]) }}

					{{ formBuilder.nodeJoin }}
					{{ formBuilder.radioList('LocationType', [
						'country': lang.LocationTypeCountry,
					], restrictedLocationType|safe, [
						'id': 'LocationTypeCountry'
					]) }}

				{{ formBuilder.endRow() }}
				{{ formBuilder.startRowGroup([ 'class': 'OptionLocationTypeCountry', 'hidden': restrictedLocationType != 'country']) }}

					{{ formBuilder.startRow([
						'label': ' ',
						'class': 'formRowIndent1',
					]) }}

					{{ formBuilder.select('LocationTypeCountries[]', availableCountries, locationTypeCountries, [
						'id': 'LocationTypeCountries',
						'class': 'Field300 ISSelectReplacement',
						'multiple': 'multiple',
						'size': 15,
					]) }}

					{{ formBuilder.endRow() }}
				{{ formBuilder.endRowGroup }}

				{{ formBuilder.startRow([
					'label': ' ',
					'class': 'formRowIndent1',
				]) }}

					{{ formBuilder.radioList('LocationType', [
						'state': lang.LocationTypeState,
					], restrictedLocationType|safe, [
						'id': 'LocationTypeState'
					]) }}

				{{ formBuilder.endRow() }}
				{{ formBuilder.startRowGroup([ 'class': 'OptionLocationTypeState', 'hidden': restrictedLocationType != 'state']) }}
					{{ formBuilder.startRow([
						'label': lang.Countries ~ ':',
						'class': 'formRowIndent1',
					]) }}

					{{ formBuilder.select('LocationTypeStatesCountries[]', availableCountries, locationTypeStatesCountries, [
						'id': 'LocationTypeStatesCountries',
						'class': 'Field300 ISSelectReplacement',
						'multiple': 'multiple',
						'size': 10,
						'onchange': 'updateLocationTypeStatesSelect(this)',
					]) }}

					{{ formBuilder.endRow() }}
					{{ formBuilder.startRow([
						'label': lang.States ~ ':',
						'class': 'formRowIndent2',
					]) }}

					{{ formBuilder.startRowGroup([ 'id': 'LocationTypeStatesSelectHolder', 'hidden': not locationTypeStatesSelect ]) }}
						<select name="LocationTypeStatesSelect[]" size="10" multiple="multiple" class="Field300 ISSelectReplacement" id="LocationTypeStatesSelect">
							{{ locationTypeStatesSelect|safe }}
						</select>
					{{ formBuilder.endRowGroup }}
					{{ formBuilder.startRowGroup([ 'id': 'LocationStateSelectNone', 'hidden': locationTypeStatesSelect ]) }}
					<div id="LocationStateSelectNone" class="BlankISSelect Field300">
						<div>{% lang 'SelectOneOrMoreCountriesFirst' %}</div>
					</div>
					{{ formBuilder.endRowGroup }}
					{{ formBuilder.endRow() }}
				{{ formBuilder.endRowGroup }}
				{{ formBuilder.startRow([
					'label': ' ',
					'class': 'formRowIndent1',
				]) }}

					{{ formBuilder.radioList('LocationType', [
						'zip': lang.LocationTypeZip,
					], restrictedLocationType|safe, [
						'id': 'LocationTypeZip'
					]) }}

				{{ formBuilder.endRow() }}
				{{ formBuilder.startRowGroup([ 'class': 'OptionLocationTypeZip', 'hidden': restrictedLocationType != 'zip']) }}
					{{ formBuilder.startRow([
						'label': lang.Country ~ ':',
						'class': 'formRowIndent1',
					]) }}

					{{ formBuilder.select('LocationTypeZipCountry', availableCountries, locationTypeZipCountry, [
						'id': 'LocationTypeZipCountry',
						'class': 'Field300 ISSelectReplacement',
					]) }}

					{{ formBuilder.endRow() }}
					{{ formBuilder.startRow([
						'label': lang.ZipPostCodes ~ ':',
						'class': 'formRowIndent2',
					]) }}

					{{ formBuilder.textarea('LocationTypeZipPostCodes', locationTypeZipPostCodes, [
						'id': 'LocationTypeZipPostCodes',
						'class': 'Field300',
						'rows': '10',
					]) }}
					
					{% lang 'ZipPostCodesPerLine' %}<br />
					<a href="#" class="LearnMoreAboutEnteringPostCodes">{% lang 'LearnMoreAboutEnteringPostCodes' %}</a>
					{{ formBuilder.endRow() }}
				{{ formBuilder.endRowGroup }}
			{{ formBuilder.endRowGroup }}
		{{ formBuilder.endForm() }}
		{{ formBuilder.startForm() }}
			{{ formBuilder.startRowGroup }}

				{{ formBuilder.heading(lang.ShippingMethodRestrictionSettings) }}
				{{ formBuilder.startRow([
					'label': lang.LimitByShipping ~ '?',
					'for': 'YesLimitByShipping',
				]) }}

					{{ formBuilder.checkbox([
						'name': 'YesLimitByShipping',
						'id': 'YesLimitByShipping',
						'label': lang.YesLimitByShipping,
						'value': 1,
						'checked': shippingMethodRestricted,
						'class': 'CheckboxTogglesOtherElements',
					]) }}
					{{ util.tooltip('LimitByShipping', 'LimitByShipping_Help') }}

				{{ formBuilder.endRow() }}
				{{ formBuilder.startRowGroup(['class': 'ShowIf_YesLimitByShipping_Checked', 'hidden': not shippingMethodRestricted]) }}

					{{ formBuilder.startRow([
						'label': ' ',
					]) }}

					{{ formBuilder.select('LocationTypeShipping[]', availableShippers, selectedShippers, [
						'id': 'LocationTypeShipping',
						'class': 'Field300 ISSelectReplacement',
						'multiple': 'multiple',
						'size': 15,
					]) }}

					{{ formBuilder.endRow() }}

				{{ formBuilder.endRowGroup }}
			{{ formBuilder.endRowGroup }}

		{{ formBuilder.endForm() }}
			</div>
		</div>
	</div>

	<div class="row">
		<div class="col-sm-12">
			<input type="submit" name="SubmitButton1" value="{% lang 'Save' %}" class="FormButton btn btn-primary">
			<input type="button" name="CancelButton1" value="{% lang 'Cancel' %}" class="FormButton btn btn-default" onclick="ConfirmCancel()"></p>
		</div>
	</div>
</form>

<iframe width=132 height=142 name="gToday:contrast:agenda.js" id="gToday:contrast:agenda.js" src="calendar/ipopeng.htm" scrolling="no" frameborder="0" style="visibility:visible; z-index:999; position:absolute; left:-500px; top:0px;"></iframe>
	<input type="text" id="dc2" name="dc2" style="display:none">
	<script src="script/coupon.form.js?{{ JSCacheToken }}" type="text/javascript" charset="utf-8"></script>
	<script type="text/javascript" src="../javascript/jquery/plugins/jstree/jquery.jstree.js?{{ JSCacheToken }}"></script>
	<script type="text/javascript" charset="utf-8">//<![CDATA[
		var currencyToken = "{{ CurrencyToken|safe }}";
		{{ util.jslang([
			'ConfirmCancelCoupon',
			'EnterCouponCode',
			'EnterCouponName',
			'ChooseCouponCategory',
			'EnterCouponProductId',
			'EnterValidAmount',
			'EnterValidMinPrice',
			'OffEachItem',
			'OffTheTotal',
			'OffTheShipping',
			'AllStatesProvinces',
			'EnterLocationOption',
			'EnterLocationTypeCountries',
			'EnterLocationTypeStatesCountries',
			'EnterLocationTypeStatesSelect',
			'EnterLocationTypeZipCountry',
			'EnterLocationTypeZipPostCodes',
			'EnterLocationTypeShipping',
			'EnterValidMaxUses',
			'EnterValidMaxUsesPerCus'
		]) }}
	//]]></script>
