<link rel="stylesheet" href="Styles/categories.css" type="text/css" />
<form method="post" id="frmCategories" action="index.php?ToDo=deleteCategory">
<div class="row">
	<div class="col-sm-12">
		<h4 class="page-title">{% lang 'ViewCategories' %}</h4>
		<p>{% lang 'ManageCatIntro' %}</p>
		{{ Message|safe }}
	</div>
</div>

<div class="row">
	<div class="col-sm-12">
		<input type="button" value="{% lang 'CreateCategory' %}..." class="btn btn-primary" onclick="document.location.href='index.php?ToDo=createCategory'" />
		<input type="button" name="CancelButton1" value="{% lang 'DeleteSelected' %}" class="btn btn-danger" onclick="ConfirmDeleteSelected()" {{ DisableDelete|safe }} />
	</div>
</div>
<br />

<div class="row">
	<div class="col-sm-12">
		<div class="panel panel-default" style="display: {{ DisplayGrid|safe }}">
			<div class="panel-body pn">
				<div class="table-responsive">
					<table class="GridPanel SortablePanel table table-striped" cellspacing="0" cellpadding="0" border="0">
						<thead>
							<tr>
								<th style="padding-left: 5px;" width="1"><input type="checkbox" id="deleteAllToggle"></th>
								<th class="NoWrap">Nome da categoria</th>
								<th width="80">Produtos</th>
								<th width="120">Visvel</th>
								<th width="120">Ao</th>
							</tr>
						</thead>
					</table>
					
					{{ CategoryList|safe }}
				</div>
			</div>
		</div>
	</div>
</div>
</form>
{% include 'category.select.modal.tpl' %}

	<div id="reassignModal" style="display: none;">
		<div class="ModalTitle">{% lang 'ReassignModalTitle' %}</div>
		<div class="ModalContent">
			<table class="Panel" width="100%">
				<tr>
					<td id="reassignCategoryModalIntro">{% lang 'ReassignModalIntro' %}</td>
				</tr>
				<tr>
					<td>
						<label>
						<input type="radio" name="reassignOption" value="reassign" id="reassignOption1" checked="checked"/>
						{% lang 'ReassignModalOption1' %}
						</label>
						<div id="parentidSelect" class="categoryPickerLinker" style="width: 98% margin: 5px;"></div>
					</td>
				</tr>
				<tr>
					<td>
						<label>
							<input type="radio" name="reassignOption" value="delete" id="reassignOption2" />
							{% lang 'ReassignModalOption2' %}
						</label>
					</td>
				</tr>
			</table>
		</div>
		<div class="ModalButtonRow">
			<div class="FloatLeft">
				<img src="images/loading.gif" alt="" style="vertical-align: middle; display: none;" class="LoadingIndicator" />
				<input type="button" class=" btn btn-default" value="{% lang 'Cancel' %}" id="cancelStep1" />
			</div>
			<input type="button" class="btn btn-primary" value="{% lang 'Continue' %} >>" id="continueStep1" />
		</div>
	</div>
	<div id="confirmModal" style="display: none;">
		<div class="ModalTitle">{% lang 'ConfirmModalTitle' %}</div>
		<div class="ModalContent">
			<table class="Panel" width="100%">
				<tr>
					<td id="confirmModalIntro"></td>
				</tr>
			</table>
		</div>
		<div class="ModalButtonRow">
			<div class="FloatLeft">
				<img src="images/loading.gif" alt="" style="vertical-align: middle; display: none;" class="LoadingIndicator" />
				<input type="button" class="CloseButton FormButton btn btn-default" value="{% lang 'Cancel' %}" id="cancelStep2" />
			</div>
			<input type="button" class="Fbtn btn-primary" value="{% lang 'ConfirmModalButton' %}" id="continueStep2" />
		</div>
	</div>
	<div id="progressModal" style="display: none;">
		<div class="ModalTitle">
			{% lang 'CategoriesDeletionInProgress' %}
		</div>
		<div class="ModalContent" style="padding:10px;">
			<div id="deletionStatus">
				<div style="width: 208px; padding: 0px; margin: 10px auto 10px auto; position: relative; background: url('images/loadingAnimation.gif') no-repeat;">
					<div id="ProgressBarPercentage" style="margin: 0; padding: 0; height: 13px; width: 0%; background: url('images/progressbar.gif') no-repeat; background-color: transparent;">
						&nbsp;
					</div>
					<div style="position: absolute; top: 0; text-align: center; width: 208px; font-weight: bold;" id="ProgressPercent">&nbsp;</div>
				</div>
				<div id="currentProgress" style="text-align:center;">
					{% lang 'DeletingProductsCategories' %}
				</div>
			</div>
			<div class="deletionReport">
				<p />
				<div id="catStatus"></div>
				<div id="prodStatus"></div>
				<p />
			</div>
		</div>
	</div>

</div>
<script type="text/javascript">
	lang.categoryVisibleConfirmation = "{% jslang 'CategoryVisibleConfirmation' %}";
	lang.categoryInvisibleConfirmation = "{% jslang 'CategoryInvisibleConfirmation' %}";
	lang.visiblityNotChanged = "{% jslang 'ErrCategoryVisibilityNotChanged' %}";
	lang.clickToHideCategory = "{% jslang 'ClickToHideCategory' %}";
	lang.clickToShowCategory = "{% jslang 'ClickToShowCategory' %}";
	lang.chooseCategoryToDelete = "{% jslang 'ChooseCategoryToDelete' %}";
	lang.chooseCategoryToUpdate = "{% jslang 'ChooseCategoryToUpdate' %}";
	lang.confirmDeleteCategories = "{% jslang 'ConfirmDeleteCategories' %}";
	lang.reassignModalIntro = "{% jslang 'ReassignModalIntro' %}";
	lang.confirmModalIntro = "{% jslang 'ConfirmModalIntro1' %}" + "{% jslang 'ConfirmModalIntro2' %}" + "{% jslang 'ConfirmModalIntro3' %}";
	lang.confirmCancel = "{% lang 'ConfirmCancel' %}";
	lang.chooseThisCategory = "{% jslang 'ChooseThisCategory' %}";
	lang.categorySelectModalIntro = "{% jslang 'CategoryMappingModalIntro' %}";
	lang.googleCategorySelectModalIntro = "{% jslang 'GoogleCategoryMappingModalIntro' %}";
	lang.categorySelectModalTitle = "{% jslang 'CategoryMappingModalTitle' %}";
	lang.categorySelectLeafCategorySelected = "{% jslang 'CategoryMappingLeafCategorySelected' %}";
	lang.googleCategorySelectLeafCategorySelected = "{% jslang 'GoogleCategoryMappingLeafCategorySelected' %}";
	lang.categorySelectChooseLeafCategory = "{% jslang 'CategoryMappingChooseLeafCategory' %}";
	lang.pleaseSelectReassignCategory = "{% jslang 'PleaseSelectReassignCategory' %}";
	lang.deletingProductsCategories = "{% jslang 'DeletingProductsCategories' %}";
	lang.deletingCategories = "{% jslang 'DeletingCategories' %}";
	lang.reassigningCategories = "{% jslang 'ReassigningCategories' %}";
	lang.ChooseGooglePsCategory = "{% jslang 'ChooseGooglePsCategory' %}";
	lang.ChooseGooglePsCategoryIntro = "{% jslang 'ChooseGooglePsCategoryIntro' %}";

	function ConfirmDeleteSelected()
	{
		var fp = document.getElementById("frmCategories").elements;
		var c = 0;

		for(i = 0; i < fp.length; i++)
		{
			if(fp[i].type == "checkbox" && fp[i].checked)
				c++;
		}

		if(c > 0)
		{
			if(confirm("ALERTA: Isto excluir permanentemente as pginas selecionadas. Voc tem certeza que deseja fazer isso?"))
				document.getElementById("frmCategories").submit();
		}
		else
		{
			alert("Por favor, escolha ao menos uma pgina para excluir.");
		}
	}

</script>

<script type="text/javascript" src="../javascript/jquery/plugins/jquery.ui.nestedSortable.js?{{ JSCacheToken }}"></script>
<script type="text/javascript" src="../javascript/jquery/plugins/idletimer/cookie.js?{{ JSCacheToken }}"></script>
<script type="text/javascript" src="script/category.manager.js?{{ JSCacheToken }}"></script>
<script type="text/javascript" src="script/category.selector.js?{{ JSCacheToken }}"></script>
<script type="text/javascript" src="../javascript/jquery/plugins/jstree/jquery.jstree.js?{{ JSCacheToken }}"></script>

<script language="javascript" type="text/javascript">//<![CDATA[
$(function(){
	CategoryManager.shoppingComparisonModules = {};

	{% for module in ShoppingComparisonModules %}
		CategoryManager.shoppingComparisonModules["{{ module.getId|js }}"] = {
			name: "{{ module.getName|js }}"
		};
	{% endfor %}
});
//]]></script>

{% include 'googleps.bulkedit.modal.tpl' %}

{% if invalidCatsMapping %}
	{% include 'googleps.category.warning.tpl' %}
	<script type="text/javascript" src="script/google.ps.category.warning.js?{{ JSCacheToken }}"></script>
{% endif %}
