<form enctype="multipart/form-data" action="index.php?ToDo={{ FormAction|safe }}" onsubmit="return ValidateForm(CheckUserForm)" id="frmUser" method="post" class="form-horizontal">
	<input type="hidden" name="userId" value="{{ UserId|safe }}">

	<div class="row">
		<div class="col-sm-12">
			<h4 class="page-title">{{ Title|safe }}</h4>
			<p>{% lang 'UserIntro' %}</p>
			{{ Message|safe }}
			{{ FlashMessages|safe }}
		</div>
	</div>

	<div class="row">
		<div class="col-sm-12">
			<input type="submit" name="IndexCreateButton" value="{% lang 'Save' %}" id="IndexCreateButton" class="btn btn-primary" />
			<input type="reset" name="IndexDeleteButton" value="{% lang 'Cancel' %}" id="IndexDeleteButton" class="btn btn-default" onclick="ConfirmDeleteSelected()" {{ DisableDelete|safe }} />
		</div>
	</div>

	<br />

	<div class="row">
		<div class="col-sm-12">
			<div class="panel panel-default">
				<div class="panel-heading"> 
					<h3 class="panel-title">{% lang 'NewUserDetails' %}</h3> 
				</div> 
				<div class="panel-body"> 
					<div class="form-group">
						<label for="username" class="control-label col-md-2">{% lang 'Username' %}</label>
						<div class="col-md-10">
							<input type="text" id="username" name="username" class="form-control" autocomplete="off" value="{{ Username|safe }}" {{ DisableUser|safe }}>
						</div>
					</div>

					<div class="form-group">
						<label for="userpass" class="control-label col-md-2">{% lang 'UserPass' %}</label>
						<div class="col-md-10">
							<input type="password" id="userpass" name="userpass" class="form-control" autocomplete="off" value="{{ UserPass|safe }}">
						</div>
					</div>

					<div class="form-group">
						<label for="userpass1" class="control-label col-md-2">{% lang 'UserPass1' %}</label>
						<div class="col-md-10">
							<input type="password" id="userpass1" name="userpass1" class="form-control" autocomplete="off" value="{{ UserPass|safe }}">
						</div>
					</div>

					<div class="form-group">
						<label for="useremail" class="control-label col-md-2">{% lang 'UserEmail' %}</label>
						<div class="col-md-10">
							<input type="text" id="useremail" name="useremail" class="form-control" value="{{ UserEmail|safe }}">
						</div>
					</div>

					<div class="form-group">
						<label for="userfirstname" class="control-label col-md-2">{% lang 'UserFirstName' %}</label>
						<div class="col-md-10">
							<input type="text" id="userfirstname" name="userfirstname" class="form-control" value="{{ UserFirstName|safe }}">
						</div>
					</div>

					<div class="form-group">
						<label for="userlastname" class="control-label col-md-2">{% lang 'UserLastName' %}</label>
						<div class="col-md-10">
							<input type="text" id="userlastname" name="userlastname" class="form-control" value="{{ UserLastName|safe }}">
						</div>
					</div>

					<div class="form-group">
						<label for="userstatus" class="control-label col-md-2">{% lang 'UserStatus' %}</label>
						<div class="col-md-10">
							<select id="userstatus" name="userstatus" class="form-control" {{ DisableStatus|safe }}>
								<option value="1" {{ Active1|safe }}>{% lang 'UserActive' %}</option>
								<option value="0" {{ Active0|safe }}>{% lang 'UserInactive' %}</option>
							</select>
						</div>
					</div>
				</div> 
			</div>

			<div class="panel panel-default">
				<div class="panel-heading"> 
					<h3 class="panel-title">{% lang 'Permissions' %}</h3> 
				</div> 
				<div class="panel-body"> 
					<div class="form-group">
						<label for="userrole" class="control-label col-md-2">{% lang 'UserRole' %}</label>
						<div class="col-md-10">
							<select name="userrole" id="userrole" class="form-control" onchange="UpdateRole(this.options[this.selectedIndex].value)" {{ DisablePermissions|safe }}>
								{{ UserRoleOptions|safe }}
							</select>
						</div>
					</div>

					{{ PermissionSelects|safe }}

					<div class="form-group">
						<label for="userlastname" class="control-label col-md-2">{% lang 'EnableXMLAPI' %}</label>
						<div class="col-md-10">
							<div class="checkbox checkbox-primary">
								<input type="checkbox" name="userapi" id="userapi" value="ON" {{ IsXMLAPI|safe }} />
		                        <label for="userapi">{% lang 'YesEnableXMLAPI' %}</label>
		                    </div>

		                    <div id="sectionXMLToken" style="display:none">
								<div class="input-group m-t-10 col-sm-8">
		                        	<span class="input-group-addon">{% lang 'XMLPath' %}</span>
		                            <input type="text" readonly="" class="form-control" value="{{ XMLPath|safe }}" id="xmlpath" name="xmlpath"/>
		                        </div>

								<div class="input-group m-t-10 col-sm-8">
		                        	<span class="input-group-addon">{% lang 'XMLToken' %}</span>
		                            <input type="text" onfocus="select(this);" readonly="" class="form-control" value="{{ XMLToken|safe }}" id="xmltoken" name="xmltoken"/>
		                        </div>
		                    </div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<div class="row">
		<div class="col-sm-12">
			<input type="submit" name="IndexCreateButton" value="{% lang 'Save' %}" id="IndexCreateButton" class="btn btn-primary" onclick="document.location.href='index.php?ToDo=createUser'" />
			<input type="button" name="IndexDeleteButton" value="{% lang 'Cancel' %}" id="IndexDeleteButton" class="btn btn-default" onclick="ConfirmDeleteSelected()" {{ DisableDelete|safe }} />
		</div>
	</div>
</form>

<script type="text/javascript" src="../javascript/passwordmeter.js"></script>
<script type="text/javascript">
	lang.PasswordStrengthMeter_MsgDefault = "{% jslang 'PasswordStrengthMeter_MsgDefault' %}";
	lang.PasswordStrengthMeter_MsgTooShort = "{% jslang 'PasswordStrengthMeter_MsgTooShort' %}";
	lang.PasswordStrengthMeter_MsgNoAlphaNum = "{% jslang 'PasswordStrengthMeter_MsgNoAlphaNum' %}";
	lang.PasswordStrengthMeter_MsgWeak = "{% jslang 'PasswordStrengthMeter_MsgWeak' %}";
	lang.PasswordStrengthMeter_MsgStrong = "{% jslang 'PasswordStrengthMeter_MsgStrong' %}";
	lang.PasswordStrengthMeter_MsgVeryStrong = "{% jslang 'PasswordStrengthMeter_MsgVeryStrong' %}";
	lang.PasswordStrengthMeter_Tip = "{% jslang 'PasswordStrengthMeter_Tip' %}";
	var meter = new PasswordStrengthMeter('userpass', 'PasswordStrengthMeter', 'PasswordStrengthTip', {{ PCIPasswordMinLen }});

	function UpdateRole(role){
			if(role == 'admin') {
				SetupPermissions('sales', true);
				SetupPermissions('manager', true);
				SetupPermissions('admin', true);
			}
			else if(role == 'manager') {
				SetupPermissions('sales', true);
				SetupPermissions('manager', true);
				SetupPermissions('admin', false);
			}
			else if(role == 'sales') {
				SetupPermissions('sales', true);
				SetupPermissions('manager', false);
				SetupPermissions('admin', false);
			}
			else {
				// Revert all permissions
				SetupPermissions('sales', false);
				SetupPermissions('manager', false);
				SetupPermissions('admin', false);

				// Now reselect based on the role
				$('.permission_select .'+role+'_role input').attr('checked', false);
				$('.permission_select .'+role+'_role input').trigger('click');
			}
		}

		function ConfirmCancel()
		{
			if(confirm("{% lang 'ConfirmCancelUser' %}"))
				document.location.href = "index.php?ToDo=viewUsers";
		}

		function CheckUserForm()
		{
			var un = document.getElementById("username");
			var up1 = document.getElementById("userpass");
			var up2 = document.getElementById("userpass1");
			var ue = document.getElementById("useremail");

			if(un.value == "") {
				alert("{% lang 'UserEnterUsername' %}");
				un.focus();
				return false;
			}

			if("{{ Adding|safe }}" == "1") {
				// client side password validation (create/copy user)
				var res = meter.validate(up1.value);
				if (res.valid == false) {
					alert(res.msg);
					up1.focus();
					return false;
				}

				if(up1.value == "") {
					alert("{% lang 'UserEnterPassword' %}");
					up1.focus();
					return false;
				}

				if(up1.value != up2.value) {
					alert("{% lang 'UserPasswordsDontMatch' %}");
					up2.focus();
					up2.select();
					return false;
				}
			}
			else
			{
				if (up1.value != '' || up2.value != '') {
					// client side password validation (edit user)
					var res = meter.validate(up1.value);
					if (res.valid == false) {
						alert(res.msg);
						up1.focus();
						return false;
					}

					if (up1.value != up2.value) {
						alert("{% lang 'UserPasswordsDontMatch' %}");
						up2.focus();
						up2.select();
						return false;
					}
				}
			}

			if(ue.value.indexOf(".") == -1 || ue.value.indexOf("@") == -1) {
				alert("{% lang 'UserInvalidEmail' %}");
				ue.focus();
				ue.select();
				return false;
			}

			if(!HasSelectedPermissions('sales') && !HasSelectedPermissions('manager') && !HasSelectedPermissions('admin')) {
				$('#permissions_sales').focus();
				alert("{% lang 'UserNoPermissions' %}");
				return false;
			}

			// Everything is OK
			return true;
		}

		function HasSelectedPermissions(type) {
			if(g('permissions_'+type+'_old')) {
				var f = $('#permissions_'+type+'_old').val();
			}
			else {
				var f = $('#permissions_'+type).val();
			}
			return f;
		}

		function SetupPermissions(type, status)
		{
			if($('#permissions_'+type).length != 1) {
				return;
			}

			if($('#permissions_'+type+'_old').length == 1) {
				if($('#permissions_'+type+'_old').attr('disabled') == true) {
					return;
				}

 				if (status) {
					$('#permissions_'+type+' li').not(".SelectedRow").trigger('click');
				} else {
					$('#permissions_'+type+' .SelectedRow').trigger('click');
				}
			}
			else {
				$('#permissions_'+type+' option').attr('selected', status);
			}
		}

		function ToggleAPI(State) {
			if(State) {
				$('#sectionXMLToken').show();
			}
			else {
				$('#sectionXMLToken').hide();
			}
		}

		function RegenerateToken() {
			$.get("{{ ShopPath|safe }}/admin/remote.php?w=generateAPIKey", null, function(data) { $('#xmltoken').val(data); } );
		}

		$(document).ready(function() {
			if('{{ IsXMLAPI|safe }}' == 'checked="checked"') {
				ToggleAPI(true);
			}
			else {
				ToggleAPI(false);
			}

			// init the password meter
			meter.init();
		});

		$('#userapi').click(function() {
			if($('#userapi').attr('checked')) {
				ToggleAPI(true);
				if($('#xmltoken').val() == '') {
					RegenerateToken();
				}
			}
			else {
				ToggleAPI(false);
			}
		});

		$('#regenlink').click(function() {
			RegenerateToken();
		});

	</script>
