<form action="index.php?ToDo=saveUpdatedReturnsSettings" name="frmReturnsSettings" id="frmReturnsSettings" method="post" onsubmit="return ValidateForm(CheckReturnsSettingsForm)">
	<div class="row">
		<div class="col-sm-12">
			<h4 class="page-title">{% lang 'ReturnsSettings' %}</h4>
			<p>{% lang 'ReturnsSettingsIntro' %}</p>
			{{ Message|safe }}
		</div>
	</div>

	<div class="row">
		<div class="col-sm-12">
			<input type="submit" value="{% lang 'Save' %}" class="btn btn-primary" />
			<input type="reset" value="{% lang 'Cancel' %}" class="btn btn-default" onclick="ConfirmCancel()" />
		</div>
	</div>
	<br>
	<div class="row">
		<div class="col-sm-12">
			<div class="panel panel-default">
				<div class="panel-heading"><h3 class="panel-title">{% lang 'ReturnsSettings' %}</h3></div>
				<div class="panel-body">
					<div class="form-group">
						<label>{% lang 'EnableReturnsSystem' %}</label>
						<label><input type="checkbox" name="enablereturns" id="enablereturns" value="1" {{ IsEnableReturns|safe }} onclick="ToggleReturnsStatus(this.checked)" /> {% lang 'YesEnableReturnsSystem' %}</label>
					</div>
				</div>
			</div>
		</div>
	</div>
	<div class="row HideOnDisabled">
		<div class="col-sm-12">
			<div class="panel panel-default">
				<div class="panel-heading"><h3 class="panel-title">{% lang 'ReturnsSettings' %}</h3></div>
				<div class="panel-body">
					<div class="form-group">
						<label>{% lang 'ReturnInstructions' %}</label>
						<textarea name="returninstructions" id="returninstructions" class="form-control" rows="6">{{ ReturnInstructions|safe }}</textarea>
					</div>

					<div class="form-group">
						<label>{% lang 'ReturnReasons' %}</label>
						<textarea name="returnreasons" id="returnreasons" class="form-control" rows="6">{{ ReturnReasonsArea|safe }}</textarea>
					</div>

					<div class="form-group">
						<label>{% lang 'ReturnActions' %}</label>
						<textarea name="returnactions" id="returnactions" class="form-control" rows="6">{{ ReturnActionsArea|safe }}</textarea>
					</div>

					<div class="form-group">
						<label>{% lang 'ReturnCredits' %}</label>
						<label><input type="checkbox" name="returncredits" id="returncredits" value="1" {{ IsReturnCredits|safe }} /> {% lang 'YesEnableReturnCredits' %}</label>
					</div>

					<div class="form-group">
						<label>{% lang 'NotifyOnReturn' %}</label>
						<label><input type="checkbox" name="returnotifyowner" id="returnotifyowner" value="1" {{ IsReturnNotifyOwner|safe }} /> {% lang 'YesEnableReturnNotifyOwner' %}</label><br />
						<label><input type="checkbox" name="returnnotifycustomer" id="returnnotifycustomer" value="1" {{ IsReturnNotifyCustomer|safe }} /> {% lang 'YesEnableReturnNotifyCustomer' %}</label><br />
						<label><input type="checkbox" name="returnnotifystatus" id="returnnotifystatus" value="1" {{ IsReturnNotifyStatusChange|safe }} /> {% lang 'YesEnableReturnNotifyStatusChange' %}</label><br />
					</div>
				</div>
			</div>
		</div>
	</div>

	<div class="row">
		<div class="col-sm-12">
			<input type="submit" value="{% lang 'Save' %}" class="btn btn-primary" />
			<input type="reset" value="{% lang 'Cancel' %}" class="btn btn-default" onclick="ConfirmCancel()" />
		</div>
	</div>
</form>

<script type="text/javascript">
	function ConfirmCancel() {
		if(confirm('{% lang 'ConfirmCancelSettings' %}')) {
			document.location.href='index.php?ToDo=viewReturnsSettings';
		} else {
			return false;
		}
	}

	function CheckReturnsSettingsForm() {
		if($('enablereturns').get().checked == true && $('#returnreasons').val() == "") {
			alert('{% lang 'EnterReturnReason' %}');
			$('#returnreasons').focus();
			$('#returnreasons').select();
			return false;
		}

		return true;
	}

	function ToggleReturnsStatus(status) {
		if(status == true) {
			$('.HideOnDisabled').show();
		} else {
			$('.HideOnDisabled').hide();
		}
	}

	$(document).ready(function () {
		if ($('#enablereturns').attr('checked') == true) {
			$('.HideOnDisabled').show();
		} else {
			$('.HideOnDisabled').hide();
		}
	});
</script>