<script type="text/javascript">
function MassActionReviews(action) {
	var sortURL = g('ReviewSortURL').href;
	sortURL = sortURL.substring(sortURL.indexOf('?')+1, sortURL.length);
	$.post('remote.php?'+sortURL+'&w='+action, $('#frmReviews').serialize(), ReviewsMassActioned);
}

function ReviewsMassActioned(response) {
	var status = $('status', response).text();
	BindAjaxGridSorting();
	var message = $('message', response).text();
	if(status == 0) {
		display_error('ReviewsStatus', message);
	} else {
		display_success('ReviewsStatus', message);
		var grid = $('grid', response).text();
		if(!grid) {
			$('#ReviewGridView').hide();
		} else {
			$('.GridContainer').html(grid);
		}
	}
}
</script>
<div class="row">
	<div class="col-sm-12">
		<h4 class="page-title">{% lang 'ManageReviews' %}</h4>
		<p>{{ ReviewIntro|safe }}</p>
		<div id="ReviewsStatus">{{ Message|safe }}</div>
	</div>
</div>

<div class="row">
	<div class="col-sm-12">
		<input type="button" name="IndexDeleteButton" value="{% lang 'DeleteReviews1' %}" id="IndexDeleteButton" class="btn btn-danger" onclick="ConfirmDeleteSelected()" {{ DisableDelete|safe }} />
		<input type="button" name="IndexApproveButton" value="{% lang 'ApproveReviews' %}" id="IndexApproveButton" class="btn btn-primary" onclick="ApproveSelected()" {{ DisableApproved|safe }} />
		<input type="button" name="IndexDisapproveButton" value="{% lang 'DisapproveReviews' %}" id="IndexDisapproveButton" class="btn bt-primary" onclick="DisapproveSelected()" {{ DisableDisapproved|safe }} />
	</div>
</div>

<div style="display: {{ DisplayGrid|safe }}" id="ReviewGridView">
	<form name="frmReviews" id="frmReviews" method="post" action="index.php?ToDo=deleteReviews">
		<div class="GridContainer">
			{{ ReviewDataGrid|safe }}
		</div>
	</form>
</div>

<script type="text/javascript">
	function PreviewReview(ReviewId) {
		var l = screen.availWidth / 2 - 250;
		var t = screen.availHeight / 2 - 300;
		var win = window.open('index.php?ToDo=previewReview&reviewId='+ReviewId, 'previewReview', 'width=500,height=600,left='+l+',top='+t+',scrollbars=1');
	}

	function CheckSearchForm() {
		var query = document.getElementById("searchQuery");

		if(query.value == "") {
			alert("{% lang 'EnterSearchTerm' %}");
			query.focus();
			return false;
		}

		return true;
	}

	function ConfirmDeleteSelected() {
		var fp = document.getElementById("frmReviews").elements;
		var c = 0;

		for(i = 0; i < fp.length; i++) {
			if(fp[i].type == "checkbox" && fp[i].checked)
				c++;
		}

		if(c > 0) {
			if(confirm("{% lang 'ConfirmDeleteReviews' %}"))
				MassActionReviews('deleteReviews');
		} else {
			alert("{% lang 'ChooseReview1' %}");
		}
	}

	function ApproveSelected() {
		var frm = document.getElementById("frmReviews");
		var fp = frm.elements;
		var c = 0;

		for(i = 0; i < fp.length; i++) {
			if(fp[i].type == "checkbox" && fp[i].checked)
				c++;
		}

		if(c > 0) {
			MassActionReviews('approveReviews');
		} else {
			alert("{% lang 'ChooseReview2' %}");
		}
	}

	function DisapproveSelected() {
		var frm = document.getElementById("frmReviews");
		var fp = frm.elements;
		var c = 0;

		for(i = 0; i < fp.length; i++) {
			if(fp[i].type == "checkbox" && fp[i].checked)
				c++;
		}

		if(c > 0) {
			MassActionReviews('disapproveReviews');
		} else {
			alert("{% lang 'ChooseReview3' %}");
		}
	}

	function ToggleDeleteBoxes(Status) {
		var fp = document.getElementById("frmReviews").elements;

		for(i = 0; i < fp.length; i++)
			fp[i].checked = Status;
	}
</script>