{% import 'order.quickview.tpl' as helper %}
{% import 'macros/util.tpl' as util %}
{% macro customFormField(field) %}
	<tr>
		<td class="text" width="120" valign="top">
			{{ field.label}}:
		</td>
		<td class="text">
			{{ field.value|join('<br />') }}
		</td>
	</tr>
{% endmacro %}


<div class="row">
    <div class="col-sm-4">
    	<div class="panel panel-default">
			<div class="panel-heading">Detalhes da cobrana</div>
			<div class="panel-body">
			  	<address>
				    <strong>Endereo de Cobrana</strong><br>
				    	{{ util.address(billingAddress) }}
				    	<br>
				    
				    <strong>{% lang 'Email' %}:</strong>
					    {% if order.custconemail %}
							<a href="mailto:{{ order.custconemail }}">{{ order.custconemail }}</a>
						{% elseif order.ordbillemail %}
							<a href="mailto:{{ order.ordbillemail }}">{{ order.ordbillemail }}</a>
						{% else %}
							{{ lang.NA }}
						{% endif %}
						<br>
					<strong>{% lang 'PhoneNumber' %}:</strong>
					    {% if order.ordbillphone %}
									{{ order.ordbillphone }}
								{% elseif order.custconphone %}
									{{ order.ordcustconphone }}
								{% else %}
									{{ lang.NA }}
								{% endif %}
						<br>
					<strong>{% lang 'OrderDate1' %}:</strong>
				    	{{ order.orddate|date('d M Y H:i:s') }}
						<br>
					<strong>{% lang 'IPAddress' %}:</strong>
					   	<a href="http://ws.arin.net/rest/ip/{{ order.ordipaddress }}" target="_blank">{{ order.ordipaddress }}</a>
						<br>

					{% if order.ordaffiliate %}
					<strong>Indicado por:</strong>
						<a href="{{ ShopPath }}/admin/index.php?ToDo=viewCustomers&idFrom={{order.ordaffiliate}}&idTo={{order.ordaffiliate}} " target="_blank">
							Afiliado Id ({{order.ordaffiliate }})
						</a>
					{% endif %}
						<br>

					{% if vendor %}
						<strong>{{ lang.Vendor}}:</strong>
				   		{{ vendor.vendorname }}
						<br>
					{% endif %}
					
					<strong>{{ lang.PaymentMethod }}</strong>
					   	{% if order.orderpaymentmethod == false %}
							{{ lang.NA }}
						{% elseif order.orderpaymentmethod != "storecredit" and order.orderpaymentmethod != "giftcertificate" %}
							{{ order.orderpaymentmethod }}
						{% endif %}

						{% if order.ordstorecreditamount > 0 %}
							<div>
								{{ lang.PaymentStoreCredit }}
								({{ order.ordstorecreditamount|currencyFormatPrice(order.orddefaultcurrencyid) }})
							</div>
						{% endif %}

						{% if order.ordgiftcertificateamount > 0 %}
							<div>
								{% lang 'PaymentGiftCertificates' with [
									'orderId': order.orderid
								] %}
								({{ order.ordgiftcertificateamount|currencyFormatPrice(order.orddefaultcurrencyid) }})
							</div>
						{% endif %}
						<br>
					{% if order.ordpayproviderid %}
						<strong>{{ lang.TransactionId }}:</strong>
						{{ order.ordpayproviderid }}
						<br>
					{% endif %}

					{% if order.ordpaymentstatus or paymentMessage %}
						<strong>{{ lang.PaymentStatus }}:</strong>
							{% if order.ordpaymentstatus %}
									{{ order.ordpaymentstatus|capitalize }}
							{% endif %}
							<div>{{ paymentMessage|safe }}</div>
							<br>
					{% endif %}
					<strong>{{ orderExtraInfo|safe }}</strong>

					{% if billingCustomFields %}
						<strong>{{ lang.BillingDetailsQuickView }}:</strong><br>
							{% for field in billingCustomFields %}
								{{ helper.customFormField(field) }}
							{% endfor %}
							<br>
					{% endif %}

					{% if order.ordcustmessage %}
						<strong>{{ lang.OrderComments }}:</strong><br>
							{{ order.ordcustmessage|nl2br }}
							<br>
					{% endif %}
				</address>
				<script>
					$(document).ready(function () {
				      $("a").click(function () {
				        if ($(this).hasClass("same-box")) {
				          $(".toggle:visible").slideUp();
				          $($(this).attr("href")).slideDown();
				          
				          return false;
				        }
				        var myelement = $(this).attr("href");
				        $(myelement).slideToggle("fast");
				        $(".toggle:visible").not(myelement).slideUp();
				        $("#bt{{order.orderid}}").hide();
				      });
				    });
				</script>
				<style>
					.toggle { display: none; } 
					.nfe { display: none; }
				</style>
				<div id ='bt{{order.orderid}}'><a class="btn btn-danger btn-sm" href="#nfe" >Enviar Nota Fiscal</a></div>
				<div class="nfe toggle" id="nfe">
					<iframe src="{{ ShopPath }}/admin/modificacoes/nf.php?pedido={{order.orderid}}" frameborder="0" width="400" height="190" marginwidth="0" marginheight="0" vspace="0" scrolling="no"></iframe>
				</div>
			</div>
		</div>
    </div>
    {% for addressId, orderAddress in orderAddresses %}
	    <div class="col-sm-4 ">
	    	<div class="panel panel-default">
				<div class="panel-heading">Detalhes de entrega</div>
				<div class="panel-body">
					{% if addressId == 0 %}
						<strong>{{ lang.DigitalItemsNotice }}</strong><br>
					{% else %}
						<address>
						    <strong>Endereo Entrega</strong><br>
						    	{{ util.address(orderAddress.address) }}
						    	<br>
							<strong>{% lang 'Email' %}:</strong>
								{% if order.custconemail %}
									<a href="mailto:{{ order.custconemail }}">{{ order.custconemail }}</a>
								{% elseif orderAddress.address.email %}
									<a href="mailto:{{ orderAddress.address.email }}">{{ orderAddress.address.email }}</a>
								{% else %}
									{{ lang.NA }}
								{% endif %}
								<br>
							<strong>{% lang 'PhoneNumber' %}:</strong>
								{% if orderAddress.address.phone %}
									{{ orderAddress.address.phone }}
								{% elseif order.custconphone %}
									{{ order.ordcustconphone }}
								{% else %}
									{{ lang.NA }}
								{% endif %}
								<br>
							{% if orderAddress.address.shipping_zone_name %}
								<strong>{% lang 'ShippingZone' %}:</strong>
									<a href="index.php?ToDo=editShippingZone&amp;zoneId={{ orderAddress.address.shipping_zone_id }}">{{ orderAddress.address.shipping_zone_name }}</a>
								<br>
							{% endif %}

							<strong>{% lang 'ShippingMethod' %}:</strong>
						    	{{ orderAddress.shipping.method }}
						    	<br>

						    <strong>{% lang 'ShippingCost' %}:</strong>
						    	{{ orderAddress.shipping.cost|currencyFormatPrice(order.orddefaultcurrencyid) }}
						    	<br>

						    <strong>{% lang 'ShippingDate' %}:</strong>
						    	{% if order.orddateshipped %}
									{{ order.orddateshipped|date('DisplayDateFormat') }}
								{% else %}
									{{ lang.NA }}
								{% endif %}
						    	<br>
						    {% if order.ordtrackingno %}
						   		<strong>{{ lang.OrdTrackingNo }}:</strong>
									{{ order.ordtrackingno }}
								<br>	
							{% endif %}

							{% if orderAddress.customFields %}
								<strong>{{ lang.ShippingDetailsQuickView }}</strong><br>
									{% for field in orderAddress.customFields %}
										{{ helper.customFormField(field) }}
									{% endfor %}
									<br>
							{% endif %}

					    </address>
					{% endif %}
				</div>
			</div>
	    </div>
	    <div class="col-sm-4 col-xs-5">
	    	<div class="panel panel-default">
				<div class="panel-heading">Detalhes dos Produtos </div>
				<div class="panel-body ">
					{% for product in orderAddress.products %}
							<table class="table">
								<tr>
									<td >
										{% if product.ordprodrefunded == product.ordprodqty %}<del>{% endif %}

										<strong>{{ product.ordprodqty }} x </strong>
										{% if product.prodname %}
											<a href="{{ product.prodlink }}" target="_blank"><strong style="white-space: normal;">{{ product.ordprodname }}</strong></a><br />
										{% else %}
											<strong>{{ product.ordprodname }}</strong><br />
										{% endif %}

										{% if product.ordprodrefunded == product.ordprodqty %}</del>{% endif %}

										{% if product.ordprodsku %}
											<strong>SKU:</strong><em>{{ product.ordprodsku }}</em><br>
										{% endif %}

										{% if product.options %}
											{% for name, value in product.options %}
												<strong>{{ name }}:</strong> {{ value }}<br>
											{% endfor %}
											
										{% endif %}

										{% if product.preorder_message %}
											<br />
											<em>({{ product.preorder_message }})</em>
										{% endif %}
									</td>

									<td align="right">
										{{ product.total|currencyFormatPrice(order.orddefaultcurrencyid) }}
									</td>
								</tr>
								{% if product.ordprodwrapname %}
									<tr>
										<td>
											{{ lang.GiftWrapping }}: {{ product.ordprodwrapname }}
											[<a href="#" onclick="$.iModal({type: 'ajax', url: 'remote.php?remoteSection=orders&w=viewGiftWrappingDetails&orderprodid={{ product.orderprodid }}' }); return false;">
												{{ lang.ViewDetails }}
											</a>]
										</td>
									</tr>
								{% endif %}

								{% if product.ordprodeventdate %}
									<tr>
										<td>
											{{ product.ordprodeventname }}: {{ product.ordprodeventdate }}
										</td>
									</tr>
								{% endif %}
								{% if product.configurable_fields %}
									<tr>
										<td class="text" colspan="2" style="padding-left: 20px">
											<strong>{{ lang.ConfigurableFields }}</strong>
											<br />
											<dl class="HorizontalFormContainer">
												{% for field in product.configurable_fields %}
													<dt>{{ field.fieldname }}:</dt>
													<dd>
														{% if field.fieldtype == 'file' %}
															<a href="{{ ShopPath }}/viewfile.php?orderprodfield={{ field.orderfieldid }}" target="_blank">
																{{ field.originalfilename }}
															</a>
														{% elseif field.fieldtype == 'checkbox' %}
															{{ lang.Checked }}
														{% elseif field.textcontents|length > 50 %}
															<a href="#" onclick="Order.LoadOrderProductFieldData({{ order.orderid }}); return false">
																<em>{{ lang.More }}</em>
															</a>
														{% else %}
															{{ field.textcontents }}
														{% endif %}
													</dd>
												{% endfor %}
											</dl>
										</td>
									</tr>
								{% endif %}
								
								


								{% if product.ordprodqtyshipped or product.ordprodrefunded %}
									<tr>
										<td class="text" colspan="2" style="padding-left: 20px">
											{% if product.ordprodqtyshipped %}
												<div class="Shipped">
													{% lang 'OrderProductsShippedX' with [
														'quantity': product.ordprodqtyshipped
													] %}
												</div>
											{% endif %}

											{% if product.ordprodrefunded %}
												<div class="Refunded">
													{% if product.ordprodrefunded == product.ordprodqty %}
														{{ lang.OrderProductRefunded }}
													{% else %}
														{% lang 'OrderProductsRefundedX' with [
															'quantity': product.ordprodrefunded
														] %}
													{% endif %}
												</div>
											{% endif %}
										</td>
									</tr>
								{% endif %}
							</table>

					{% endfor %}
					{% if addressId == 0 %}
						<strong>{{ lang.DigitalItemDetails }}</strong>
					{% else %}
						<span>
							{% if orderAddress.shipping.total_shipped < orderAddress.address.total_items %}
								{% if order.deleted %}
									<span class="Disabled" title="{% lang 'deletedOrderToolTip' %}">{% lang 'ShipItems' %}</span>
								{% else %}
									<a class="btn btn-primary btn-sm" href="#" onclick="Order.ShipItems({{ order.orderid }}, {{ addressId }}); return false;">{{ lang.ShipItems }}</a>
								{% endif %}
							{% endif %}
							{% if orderAddress.shipping.total_shipped > 0 %}
								<a href="#" class="btn btn-primary btn-sm" onclick="Order.viewShipments({{ order.orderid }}); return false">{{ lang.ViewShipments }}</a>
							{% endif %}
						</span>
						<div style="display: {{Hidedeclaracao|safe}}">
							<br>
							<a class="btn btn-primary btn-sm" href="#" onclick="window.open('{{ ShopPath }}/admin/modificacoes/declaracao.php?pedido={{order.orderid}}', 'Gerador Declaracao correios', 'STATUS=NO, titlebar=0,directories=0,TOOLBAR=NO, LOCATION=NO, DIRECTORIES=NO, RESISABLE=NO, SCROLLBARS=NO, WIDTH=600, HEIGHT=700');">Gerar Declarao</a>
						</div>

					{% endif %}
					
					

					<div class="orderQuickViewShippingBlockLast">
						<div class="orderQuickViewShippingBlockDetails">
							&nbsp;
						</div>
						<div class="orderQuickViewShippingBlockItems">
							<table width="95%" align="center" border="0" cellspacing="0" cellpadding="2">
								{% for id, total in totalRows %}
									<tr class="orderQuickViewTotal{{ id|capitalize }}">
										<td height="18" class="text" align="right"><strong>{{ total.label }}:<s/trong></td>
										<td align="right" class="orderQuickViewPriceColumn">{{ total.value|currencyFormatPrice(order.orddefaultcurrencyid) }}</td>
									</tr>
								{% endfor %}
								{% if order.ordrefundedamount > 0 %}
									<tr class="orderQuickViewTotal{{ id|capitalize }}">
										<td height="18" class="text" align="right"><strong>{{ lang.Refunded }}:</strong></td>
										<td align="right" class="orderQuickViewPriceColumn" style="color: maroon">-{{ order.ordrefundedamount|currencyFormatPrice(order.orddefaultcurrencyid) }}</td>
									</tr>
								{% endif %}
							</table>
						</div>
						<br style="clear: both" />
					</div>
				</div>
			</div>
	    </div>
	{% endfor %}
</div>