<!DOCTYPE html>
<html>
<head>
	<title>{% lang 'ControlPanel' %}</title>
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<meta charset="utf-8">
	<link rel="shortcut icon" href="favicon.ico">
	<link href="new/css/bootstrap.min.css" rel="stylesheet" />
	<link href="new/assets/font-awesome/css/font-awesome.min.css" rel="stylesheet" />
	<link href="new/assets/ionicon/css/ionicons.min.css" rel="stylesheet" />
	<link href="new/css/material-design-iconic-font.min.css" rel="stylesheet">
	<link href="new/css/animate.css" rel="stylesheet" />
	<link href="new/css/waves-effect.css" rel="stylesheet">
	<link href="new/new/css/helper.css" rel="stylesheet" type="text/css" />
	<link href="new/css/style.css" rel="stylesheet" type="text/css" />
	<script src="new/js/modernizr.min.js"></script>
</head>

<body>
	<div class="wrapper-page">
		{{ FlashMessages|safe }}
		<div class="panel panel-default panel-pages">
			<div class="panel-heading"> 
				<h3 class="text-center m-t-10 panel-title">Painel de <strong>Administrador</strong> </h3>
			</div> 

			<div class="panel-body">
				<form class="form-horizontal m-t-20" action="index.php?ToDo={{ SubmitAction|safe }}" method="POST">
					<div class="form-group ">
						<div class="col-xs-12">
							<input class="form-control input-lg" style="width: 100%!important;border: none;" type="text" name="username" id="username" required placeholder="{% lang 'Username' %}" value="{{ Username|safe }}">
						</div>
					</div>

					<div class="form-group">
						<div class="col-xs-12">
							<input class="form-control input-lg" type="password" style="width: 100%!important;border: none;" name="password" id="password" required="" placeholder="{% lang 'Password' %}" value="{{ Password|safe }}">
						</div>
					</div>

					{% if ShowRememberMe %}
					<div class="form-group ">
						<div class="col-md-6">
							<div class="checkbox checkbox-primary">
								<input name="remember" id="remember" value="ON" type="checkbox">
								<label for="remember">{% lang 'RememberMe' %}</label>
							</div>
						</div>
						<div class="col-md-6">
							<a href="index.php?ToDo=forgotPass" class="pull-right" style="margin-top: 5px;"><i class="fa fa-lock m-r-5"></i> Esqueci minha senha</a>
						</div>
					</div>
					{% endif %}

					<div class="col-md-12">
						<div class="form-group pull-right">
							<button class="btn btn-primary waves-effect waves-light" type="submit">{% lang 'Login' %}</button>
						</div>
					</div>
				</form> 
			</div>
		</div>
	</div>
</body>
</html>