<form enctype="multipart/form-data" action="index.php" id="frmSearch" method="get" onsubmit="return ValidateForm(CheckSearchForm)">
	<input type="hidden" name="ToDo" value="searchProductsRedirect" />

	<div class="row">
		<div class="col-sm-12">
			<h4 class="page-title">{% lang 'SearchProducts' %}</h4>
			<p>{% lang 'SearchProductsIntro' %}</p>
			{{ Message|safe }}
		</div>
	</div>

	<div class="row">
		<div class="col-sm-12">
			<input type="submit" value="Pesquisar" class="btn btn-primary" />
			<input type="reset" value="{% lang 'Cancel' %}" class="btn btn-default" onclick="ConfirmCancel()" />
		</div>
	</div>
	<br>

	<div class="row">
		<div class="col-sm-12">
			<div class="panel panel-default">
				<div class="panel-heading"><h3 class="panel-title">{% lang 'AdvancedSearch' %}</h3></div>
				<div class="panel-body">
					<div class="form-group">
						<label>{% lang 'SearchKeywords' %}</label>
						<input type="text" id="searchQuery" name="searchQuery" class="form-control">
					</div>

					<div class="form-group">
						<label>{% lang 'BrandName' %}</label>
						<select name="brand" id="brand" class="form-control">
							<option value="" selected="selected">{% lang 'AllBrandNames' %}</option>
							{{ BrandNameOptions|safe }}
						</select>
					</div>

					<div class="form-group">
						<label>{% lang 'Categories' %}</label>
						<select size="5" id="category" name="category[]" class="Field250 ISSelectReplacement form-control" style="height:150; width: 100%" multiple>
							<option value="0" selected="selected">{% lang 'AllCategories' %}</option>
							{{ CategoryOptions|safe }}
						</select>
						<br />
						<div style="clear: left;"><label><input type="checkbox" name="subCats" value="1" checked="checked" /> {% lang 'AutoSearchSubCategories' %}</label></div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<div class="row">
		<div class="col-sm-12">
			<div class="panel panel-default">
				<div class="panel-heading"><h3 class="panel-title">{% lang 'SearchBySetting' %}</h3></div>
				<div class="panel-body">
					<div class="form-group">
						<label>{% lang 'ProductVisibility' %}</label>
						<select name="visibility" id="visibility" class="form-control">
							<option value="">{% lang 'NoPreference' %}</option>
							<option value="1">{% lang 'VisibleOnly' %}</option>
							<option value="0">{% lang 'InvisibleOnly' %}</option>
						</select>
					</div>

					<div class="form-group">
						<label>{% lang 'FeaturedProduct' %}</label>
						<select name="featured" id="featured" class="form-control">
							<option value="">{% lang 'NoPreference' %}</option>
							<option value="1">{% lang 'FeaturedOnly' %}</option>
							<option value="0">{% lang 'NotFeaturedOnly' %}</option>
						</select>
					</div>

					<div class="form-group">
						<label>{% lang 'FreeShipping' %}</label>
						<select name="freeShipping" id="freeShipping" class="form-control">
							<option value="">{% lang 'NoPreference' %}</option>
							<option value="1">{% lang 'FreeShippingOnly' %}</option>
							<option value="0">{% lang 'NonFreeShippingOnly' %}</option>
						</select>
					</div>
				</div>
			</div>
		</div>
	</div>

	<div class="row">
		<div class="col-sm-12">
			<div class="panel panel-default">
				<div class="panel-heading"><h3 class="panel-title">{% lang 'SortOrder' %}</h3></div>
				<div class="panel-body">
					<div class="form-group">
						<label>{% lang 'SortOrder' %}</label>
						<select name="sortField" class="Field120">
							<option value="productid">{% lang 'ProductID' %}</option>
							<option value="prodcode">{% lang 'ProductSKU' %}</option>
							<option value="prodcurrentinv">{% lang 'ProductInStock' %}</option>
							<option value="prodname">{% lang 'ProductName' %}</option>
							<option value="prodcalculatedprice">{% lang 'ProductPrice' %}</option>
							<option value="prodvisble">{% lang 'ProductVisible' %}</option>
						</select>
					</div>

					<div class="form-group">
						<label>{% lang 'SortOrder' %}</label>
						<select name="featured" id="featured" class="form-control">
							<option value="">{% lang 'NoPreference' %}</option>
							<option value="1">{% lang 'FeaturedOnly' %}</option>
							<option value="0">{% lang 'NotFeaturedOnly' %}</option>
						</select>
					</div>

					<div class="form-group">
						<label>{% lang 'FreeShipping' %}</label>
						<select name="sortOrder" class="form-control">
							<option value="asc">{% lang 'AscendingOrder' %}</option>
							<option value="desc">{% lang 'DescendingOrder' %}</option>
						</select>
					</div>
				</div>
			</div>
		</div>
	</div>

	<div class="row">
		<div class="col-sm-12">
			<input type="submit" value="Pesquisar" class="btn btn-primary" />
			<input type="reset" value="{% lang 'Cancel' %}" class="btn btn-default" onclick="ConfirmCancel()" />
		</div>
	</div>
</form>
	<script type="text/javascript">
		function ConfirmCancel() {
			if(confirm("{% lang 'ConfirmCancelSearch' %}"))
				document.location.href = "index.php?ToDo=viewProducts";
		}

		function CheckSearchForm() {
			var priceFrom = document.getElementById("priceFrom");
			var priceTo = document.getElementById("priceTo");
			var inventoryFrom = document.getElementById("inventoryFrom");
			var inventoryTo = document.getElementById("inventoryTo");
			var soldFrom = document.getElementById("soldFrom");
			var soldTo = document.getElementById("soldTo");

			if(priceFrom.value != "" && isNaN(priceFormat(priceFrom.value))) {
				alert("{% lang 'SearchEnterValidPrice' %}");
				priceFrom.focus();
				priceFrom.select();
				return false;
			}

			if(priceTo.value != "" && isNaN(priceFormat(priceTo.value))) {
				alert("{% lang 'SearchEnterValidPrice' %}");
				priceTo.focus();
				priceTo.select();
				return false;
			}

			if(inventoryFrom.value != "" && isNaN(inventoryFrom.value)) {
				alert("{% lang 'SearchEnterValidInventoryLvl' %}");
				inventoryFrom.focus();
				inventoryFrom.select();
				return false;
			}

			if(inventoryTo.value != "" && isNaN(inventoryTo.value)) {
				alert("{% lang 'SearchEnterValidInventoryLvl' %}");
				inventoryTo.focus();
				inventoryTo.select();
				return false;
			}

			if(soldFrom.value != "" && isNaN(soldFrom.value)) {
				alert("{% lang 'SearchEnterValidQtySold' %}");
				soldFrom.focus();
				soldFrom.select();
				return false;
			}

			if(soldTo.value != "" && isNaN(soldTo.value)) {
				alert("{% lang 'SearchEnterValidQtySold' %}");
				soldTo.focus();
				soldTo.select();
				return false;
			}

			return true;
		}

	</script>
