{% import "macros/forms.tpl" as forms %}
{% import "macros/util.tpl" as util %}
<link rel="stylesheet" type="text/css" href="Styles/orders.css" media="all" />

<div class="row">
	<div class="col-sm-12">
		<h4 class="page-title">{% lang 'View' %}: <a href="#" style="color:#005FA3" id="ViewsMenuButton" class="PopDownMenu">{{ ViewName|safe }} <img width="8" height="5" src="images/arrow_blue.gif" border="0" /></a></h4>
		<div id="ViewsMenu" class="DropDownMenu DropShadow" style="display: none; width:200px">
			<ul>
				{{ CustomSearchOptions|safe }}
			</ul>
			<hr />
			<ul>
				<li><a href="index.php?ToDo=createOrderView" style="background-image:url('images/view_add.gif'); background-repeat:no-repeat; background-position:5px 5px; padding-left:28px">{% lang 'CreateANewView' %}</a></li>
				<li style="display:{{ HideDeleteViewLink|safe }}"><a onclick="$('#ViewsMenu').hide(); confirm_delete_custom_search('{{ CustomSearchId|safe }}')" href="javascript:void(0)" style="background-image:url('images/view_del.gif'); background-repeat:no-repeat; background-position:5px 5px; padding-left:28px">{% lang 'DeleteThisView' %}</a></li>
			</ul>
		</div>
		<p>{{ OrderIntro|safe }}</p>
		<div id="CustomerStatus">{{ Message|safe }}</div>
	</div>
</div>

<div class="row">
	<div class="col-md-8">
		<input type="submit" value="Adicionar Pedido" class="btn btn-primary"onclick="document.location.href='index.php?ToDo=addOrder'" />
		{% if disableOrderExports %}
		<input type="button" value="{% lang 'ExportTheseOrders' %}" disabled="disabled" class="btn btn-success PopDownMenu" />
		{% else %}
		<input type="button" value="Exportar estes pedidos" id="OrderExportMenuButton" class="btn btn-success PopDownMenu" />
		{% endif %}
		{% if not disableOrderExports %}
			{{ util.dropDownMenu([
				'id': 'OrderExportMenu',
				'groups': orderExportMenu,
			]) }}
		{% endif %}

		<span class="acoes" style="display: {{ DisplayGrid|safe }}">
			<select id="OrderActionSelect" name="OrderActionSelect" class="form-control" style="display: inline; width: 30%">
				{{ OrderActionOptions|safe }}
			</select>
			<input type="button" id="OrderActionButton" name="OrderActionButton" value="{% lang 'OrderActionButton' %}" class="btn btn-primary" onclick="HandleOrderAction()" />
		</span>
	</div>

	<div class="col-md-4" style="display:{{ DisplaySearch|safe }}">
		<form name="frmOrders" id="frmOrders" action="index.php" method="get">
			{{ forms.hiddenInputs(['ToDo':'viewOrders'] + searchURL, ['searchQuery']) }}

			<div class="form-group">
				<input name="searchQuery" style="width: 86%; display: inline;" id="searchQuery" type="text" value="{{ QueryEscaped|safe }}" id="SearchQuery" class="form-control" placeholder="Pesquisar" />
				<input type="submit" class="btn btn-primary" value="OK">
				<p><small><a href="index.php?ToDo=searchOrders">{% lang 'AdvancedSearch' %}</a><span style="display:{{ HideClearResults|safe }}">| <a id="SearchClearButton" href="index.php?ToDo=viewOrders">{% lang 'ClearResults' %}</a></span></small></p>
			</div>
		</form>
	</div>
</div>

<div class="row" style="display: {{ DisplayGrid|safe }}">
	<div class="col-md-12">
		<form name="frmOrders1" id="frmOrders1" method="post" action="index.php?ToDo=deleteOrders">
			<div class="GridContainer" id="GridContainer">
				{{ OrderDataGrid|safe }}
			</div>
		</form>
	</div>
</div>

<script language="javascript" type="text/javascript">
//<![CDATA[
config.DeletedOrdersAction = "{{ ISC_CFG.DeletedOrdersAction|js }}";
var tok = "{{ AuthToken|safe }}";
var delete_orders_choose_message = "{% lang 'ChooseOrder' %}";
var print_orders_choose_message = "{% lang 'ChooseOrderInvoice' %}";
var confirm_delete_orders_message = "{% lang 'ConfirmDeleteOrders' %}";
var order_status_update_success_message = "{% lang 'OrderStatusUpdated' %}";
var failed_order_status_update_message = "{% lang 'OrderStatusUpdateFailed' %}";
var confirm_update_order_status_message = "{% lang 'ConfirmUpdateOrderStatus' %}";
var trackingno_update_success_message = "{% lang 'TrackingNoUpdated' %}";
var trackingno_update_failed_message = "{% lang 'TrackingNoUpdateFailed' %}";
var delete_custom_search_message = "{% lang 'ConfirmDeleteCustomSearch' %}";
var update_order_status_choose_message = "{% lang 'ChooseOrderUpdateStatus' %}";
var choose_action_option = "{% lang 'ChooseActionFirst' %}";

{{ util.jslang([
	'ChooseOneMoreItemsToShip',
	'ProblemCreatingShipment',
	'SavingNotes',
	'ConfirmDelayCapture',
	'ConfirmRefund',
	'ConfirmVoid',
	'SelectRefundType',
	'EnterRefundAmount',
	'InvalidRefundAmountFormat',
	'ConfirmSendTrackingNumber',
	'TrackingLinkEmailed',
	'ShipOrderMultipleAddressInstructions',
	'ConfirmDeleteOrders',
	'ConfirmRestorableDeleteOrders',
	'ChooseOrderUndelete',
	'ChooseOrderPurge',
	'ConfirmUndeleteOrders',
	'OrderDeletedGeneralNotice',
]) }}

$(document).ready(function() {
	{{ SelectOrder|safe }}
});

{% if disableOrderExports %}
var ExportAction = "{{ ExportAction|safe }}";
{% endif %}
//]]>
</script>
<script type="text/javascript" src="script/order.js?{{ JSCacheToken }}"></script>

{% if not disableOrderExports %}
	{% include 'emailintegration.export.javascript.tpl' %}
{% endif %}