<div class="row">
	<div class="col-sm-12">
		<h4 class="page-title">{% lang 'ViewNews' %}</h4>
		<p>{{ NewsIntro|safe }}</p>
		{{ Message|safe }}
	</div>
</div>

<div class="row">
	<div class="col-sm-12">
		<input type="button" name="IndexAddButton" value="{% lang 'AddNews' %}..." id="IndexCreateButton" class="btn btn-primary" onclick="document.location.href='index.php?ToDo=addNews'" /> 
		<input type="button" name="IndexDeleteButton" value="{% lang 'DeleteSelected' %}" id="IndexDeleteButton" class="btn btn-danger" onclick="ConfirmDeleteSelected()" {{ DisableDelete|safe }} />
	</div>
</div>
<br />

<div class="panel panel-default" style="display: {{ DisplayGrid|safe }}">
	<div class="panel-body pn">
		<div class="table-responsive">
			<form name="frmNews" id="frmNews" method="post" action="index.php?ToDo=deleteNews">
				<div class="GridContainer">
					{{ NewsDataGrid|safe }}
				</div>
			</form>
		</div>
	</div>
</div>

<script type="text/javascript">
	function CheckSearchForm(){
			var query = document.getElementById("searchQuery");

			if(query.value == "")
			{
				alert("{% lang 'EnterSearchTerm' %}");
				return false;
			}

			return true;
		}

		function ConfirmDeleteSelected()
		{
			var fp = document.getElementById("frmNews").elements;
			var c = 0;

			for(i = 0; i < fp.length; i++)
			{
				if(fp[i].type == "checkbox" && fp[i].checked)
					c++;
			}

			if(c > 0)
			{
				if(confirm("{% lang 'ConfirmDeleteNews' %}"))
					document.getElementById("frmNews").submit();
			}
			else
			{
				alert("{% lang 'ChooseNews' %}");
			}
		}

		function ToggleDeleteBoxes(Status)
		{
			var fp = document.getElementById("frmNews").elements;

			for(i = 0; i < fp.length; i++)
				fp[i].checked = Status;
		}

		function PreviewNews(NewsId)
		{
			var l = screen.availWidth / 2 - 300;
			var t = screen.availHeight / 2 - 300;
			var win = window.open('index.php?ToDo=prevNews&newsId='+NewsId, 'newsPreview', 'width=600,height=600,left='+l+',top='+t+',scrollbars=1');
		}

	</script>
