{% import "macros/util.tpl" as util %}
{% import "macros/forms.tpl" as formBuilder %}
<script type="text/javascript" src="../javascript/formfield.js?{{ JSCacheToken }}"></script>
<form action="index.php?ToDo={{ FormAction|safe }}" onsubmit="return ValidateForm(checkAddCustomerAddressForm)" id="frmCustomerAddress" method="post">
	<input type="hidden" name="addressId" id="addressId" value="{{ AddressId|safe }}">
	<input type="hidden" name="customerId" id="customerId" value="{{ CustomerId|safe }}">
	<input type="hidden" name="newCustomer" id="newCustomer" value="{{ NewCustomer|safe }}">
	<input type="hidden" name="customFieldsAddressFormId" id="customFieldsAddressFormId" value="{{ CustomFieldsAddressFormId|safe }}">
	<input id="currentTab" name="currentTab" value="0" type="hidden">

	<div class="row">
		<div class="col-sm-12">
			<h4 class="page-title">{{ Title|safe }}</h4>
			<p>{{ Intro|safe }}</p>
			{{ Message|safe }}
		</div>
	</div>

	<div class="row">
		<div class="col-sm-12">
			<input type="submit" value="{% lang 'SaveAndExit' %}" class="btn btn-primary" name="SaveButton1" />
			<input type="submit" value="{{ SaveAndAddAnother|safe }}" name="SaveAddAnotherButton1" onclick="saveAndAddAnother();" class="btn btn-primary" />
			<input type="reset" value="{% lang 'Cancel' %}" class="btn btn-default" name="CancelButton1" onclick="confirmCancel()" />
		</div>
	</div>
	<br />

	<div class="panel panel-default form-horizontal">
		<div class="panel-heading"> 
			<h3 class="panel-title">{% lang 'CustomerDetails' %}</h3> 
		</div> 

		<div class="panel-body">
			{{ AddressFields|safe }}
			{{ CustomFields|safe }}
		</div>
	</div>

	<div class="row">
		<div class="col-sm-12">
			<input type="submit" value="{% lang 'SaveAndExit' %}" class="btn btn-primary" name="SaveButton1" />
			<input type="submit" value="{{ SaveAndAddAnother|safe }}" name="SaveAddAnotherButton1" onclick="saveAndAddAnother();" class="btn btn-primary" />
			<input type="reset" value="{% lang 'Cancel' %}" class="btn btn-default" name="CancelButton1" onclick="confirmCancel()" />
		</div>
	</div>
</form>

<script type="text/javascript"><!--

	function saveAndAddAnother() {
		MakeHidden('addanother', '1', 'frmCustomerAddress');
	}

	function confirmCancel() {
		if(confirm('{{ CancelMessage|safe }}')) {
			if ("{{ CancelGoToManager|safe }}" == "1") {
				document.getElementById('frmCustomerAddress').action = 'index.php?ToDo=viewCustomers';
			} else {
				document.getElementById('frmCustomerAddress').action = 'index.php?ToDo=editCustomer&customerId={{ CustomerId|safe }}';
				MakeHidden('currentTab', '1', 'frmCustomerAddress');
			}

			document.getElementById('frmCustomerAddress').submit();
			return false;
		} else {
			return false;
		}
	}

	function checkAddCustomerAddressForm()
	{
		var formfields = FormField.GetValues({{ CustomFieldsAddressFormId|safe }});

		for (var i=0; i<formfields.length; i++) {
			var rtn = FormField.Validate(formfields[i].field);

			if (!rtn.status) {
				alert(rtn.msg);
				FormField.Focus(formfields[i].field);
				return false;
			}
		}

		return true;
	}

	{{ FormFieldEventData|safe }}

//--></script>