<div class="row">
	<div class="col-sm-12">
		<h4 class="page-title">{% lang 'ViewCoupons' %}</h4>
		<p>{{ CouponIntro|safe }}</p>
		{{ Message|safe }}
	</div>
</div>

<div class="row">
	<div class="col-sm-12">
		<input type="button" name="IndexAddButton" value="{% lang 'CreateCoupon' %}..." id="IndexCreateButton" class="btn btn-primary" onclick="document.location.href='index.php?ToDo=createCoupon'" /> 
		<input type="button" name="IndexDeleteButton" value="{% lang 'DeleteSelected' %}" id="IndexDeleteButton" class="btn btn-danger" onclick="ConfirmDeleteSelected()" {{ DisableDelete|safe }} />
	</div>
</div>
<br />

<div class="panel panel-default" style="display: {{ DisplayGrid|safe }}">
	<div class="panel-heading"> 
		<h3 class="panel-title">Cupons de Desconto</h3> 
	</div>
	<div class="panel-body pn">
		<div class="table-responsive">
			<form name="frmCoupons" id="frmCoupons" method="post" action="index.php?ToDo=deleteCoupons">
				<div class="GridContainer">
					{{ CouponsDataGrid|safe }}
				</div>
			</form>
		</div>
	</div>
</div>

<script type="text/javascript">
	function ConfirmDeleteSelected()
		{
			var fp = document.getElementById("frmCoupons").elements;
			var c = 0;

			for(i = 0; i < fp.length; i++)
			{
				if(fp[i].type == "checkbox" && fp[i].checked)
					c++;
			}

			if(c > 0)
			{
				if(confirm("{% lang 'ConfirmDeleteCoupons' %}"))
					document.getElementById("frmCoupons").submit();
			}
			else
			{
				alert("{% lang 'ChooseCoupons' %}");
			}
		}

		function ToggleDeleteBoxes(Status)
		{
			var fp = document.getElementById("frmCoupons").elements;

			for(i = 0; i < fp.length; i++)
				fp[i].checked = Status;
		}

		function CouponClipboard(Data)
		{
			if (window.clipboardData)
			{
				window.clipboardData.setData("Text", Data);
				alert("{% lang 'CopiedClipboard' %}");
			}
			else
			{
				alert("{% lang 'FeatureOnlyInIE' %}");
			}
		}

	</script>