<div class="row">
	<div class="col-sm-12">
		<h4 class="page-title">{% lang 'ViewBrands' %}</h4>
		<p>{{ BrandIntro|safe }}</p>
		{{ Message|safe }}
	</div>
</div>

<div class="row">
	<div class="col-sm-12">
		<input type="button" name="IndexAddButton" value="{% lang 'AddBrand' %}" id="IndexCreateButton" class="btn btn-primary" onclick="document.location.href='index.php?ToDo=addBrand'" /> 
		<input type="button" name="IndexDeleteButton" value="{% lang 'DeleteSelected' %}" id="IndexDeleteButton" class="btn btn-danger" onclick="ConfirmDeleteSelected()" {{ DisableDelete|safe }} />
	</div>
</div>
<br />

<div class="panel panel-default" style="display: {{ DisplayGrid|safe }}">
	<div class="panel-body pn">
		<div class="table-responsive">
			<form name="frmBrands" id="frmBrands" method="post" action="index.php?ToDo=deleteBrands">
				<div class="GridContainer">
					{{ BrandsDataGrid|safe }}
				</div>
			</form>
		</div>
	</div>
</div>

<script type="text/javascript">
	function CheckSearchForm()
	{
		var query = document.getElementById("searchQuery");

		if(query.value == "")
		{
			alert("{% lang 'EnterSearchTerm' %}");
			return false;
		}

		return true;
	}

	function ConfirmDeleteSelected()
	{
			var fp = document.getElementById("frmBrands").elements;
			var c = 0;

			for(i = 0; i < fp.length; i++)
			{
				if(fp[i].type == "checkbox" && fp[i].checked)
					c++;
			}

			if(c > 0)
			{
				if(confirm("{% lang 'ConfirmDeleteBrands' %}"))
					document.getElementById("frmBrands").submit();
			}
			else
			{
				alert("{% lang 'ChooseBrands' %}");
			}
		}

		function ToggleDeleteBoxes(Status)
		{
			var fp = document.getElementById("frmBrands").elements;

			for(i = 0; i < fp.length; i++)
				fp[i].checked = Status;
		}

	</script>
